% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.glsm.R
\name{summary.glsm}
\alias{summary.glsm}
\title{Summary Method for in \code{glsm} Objects}
\usage{
\method{summary}{glsm}(object, ...)
}
\arguments{
\item{object}{The \code{glsm} model to summarize. The details of the model specification are provided under \strong{Details}.}

\item{...}{Other arguments passed to or from other methods.}
}
\value{
"summary.glsm" returns an object of class \code{summary.glsm}, a list with components:
\item{Call}{The original call used to fit the model.}
\item{coeff}{A matrix of coefficients with columns for the estimated coefficients (Coef(B)),
standard errors (Std.Error), exponentiated coefficients (Exp(B)), Wald test statistics (Wald),
degrees of freedom (DF), and the corresponding p-values (P.value).}
\item{comparison test}{A matrix with comparison tests of the logistic model against the following models:
Null, Complete, and Saturated. It includes the test statistic (Deviance), degrees of freedom (DF),
and p-values (P.value).}

#' @details The \code{glsm} function estimates a multinomial logistic regression model when the response variable takes more than two levels.
The model compares the logistic specification against nested models (null, complete, and saturated), and provides maximum likelihood estimates,
asymptotic inference for coefficients, and goodness-of-fit measures. This summary method presents the key components of the model in a structured format.
}
\description{
Summarizes a fitted \code{glsm} model, including coefficients, standard errors, odds ratios, Wald tests, and likelihood-ratio comparisons with nested models.
}
\details{
Summary Method for 'glsm'
}
\examples{
data("hsbdemo", package = "glsm")
model <- glsm(prog ~ ses + gender, data = hsbdemo)
summary(model)

}
\references{
Hosmer, D., Lemeshow, S., & Sturdivant, R. (2013). \emph{Applied Logistic Regression} (3rd ed.). New York: Wiley. ISBN: 978-0-470-58247-3
Llinás, H. (2006). Precisiones en la teoría de los modelos logísticos. \emph{Revista Colombiana de Estadística}, 29(2), 239–265.
Llinás, H., & Carreño, C. (2012). The Multinomial Logistic Model for the Case in Which the Response Variable Can Assume One of Three Levels and Related Models. \emph{Revista Colombiana de Estadística}, 35(1), 131–138.
Orozco, E., Llinás, H., & Fonseca, J. (2020). Convergence theorems in multinomial saturated and logistic models. \emph{Revista Colombiana de Estadística}, 43(2), 211–231.
Llinás, H., Arteta, M., & Tilano, J. (2016). El modelo de regresión logística para el caso en que la variable de respuesta puede asumir uno de tres niveles: estimaciones, pruebas de hipótesis y selección de modelos. \emph{Revista de Matemática: Teoría y Aplicaciones}, 23(1), 173–197.
}
\author{
Humberto Llinás (Universidad del Norte, Barranquilla-Colombia; author),
Jorge Villalba (Universidad Tecnológica de Bolívar, Cartagena-Colombia; author and creator),
Jorge Borja (Universidad del Norte, Barranquilla-Colombia; author and creator),
Jorge Tilano (Universidad del Norte, Barranquilla-Colombia; author)
}
