% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwfit.R
\name{print.summary.gkwfit}
\alias{print.summary.gkwfit}
\title{Print Method for summary.gkwfit Objects}
\usage{
\method{print}{summary.gkwfit}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars", TRUE),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"summary.gkwfit"}, usually the result of
\code{summary(gkwfit_object)}.}

\item{digits}{Integer; the minimum number of significant digits to display
for numeric values. Defaults to \code{max(3L, getOption("digits") - 3L)}.}

\item{signif.stars}{Logical; if \code{TRUE}, p-values are additionally encoded
visually using "significance stars". Defaults to
\code{getOption("show.signif.stars", TRUE)}.}

\item{...}{Additional arguments passed to \code{\link[stats]{printCoefmat}}.}
}
\value{
Invisibly returns the original input object \code{x}. Called primarily
for its side effect of printing the summary to the console.
}
\description{
Prints the formatted summary of a \code{gkwfit} model object, generated by
\code{summary.gkwfit}. It displays the call, family, coefficient table
(with estimates, standard errors, z-values, p-values, and significance stars*),
fit statistics (LogLik, AIC, BIC, AICc), number of parameters and observations,
fixed parameters (if any), fit method, convergence status including optimizer
message, and optionally the correlation matrix of coefficients.
\itemize{
\item Significance stars are shown next to p-values by default if standard errors
were available.
}
}
\seealso{
\code{\link{summary.gkwfit}}, \code{\link{gkwfit}}, \code{\link[stats]{printCoefmat}}
}
\author{
Lopes, J. E. (with refinements)
}
\keyword{internal}
\keyword{methods}
\keyword{print}
