% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_rescale.r
\docType{data}
\name{position_rescale}
\alias{position_rescale}
\alias{PositionRescale}
\alias{position_yrescale}
\alias{position_xrescale}
\title{Rescale x or y onto new range in margin}
\format{
An object of class \code{PositionRescale} (inherits from \code{Position}, \code{ggproto}, \code{gg}) of length 10.
}
\usage{
position_rescale(
  rescale = "y",
  midpoint = NULL,
  range = NULL,
  location = NULL,
  instance = NULL
)

position_yrescale(
  rescale = "y",
  midpoint = NULL,
  range = NULL,
  location = NULL,
  instance = NULL
)

position_xrescale(
  rescale = "x",
  midpoint = NULL,
  range = NULL,
  location = NULL,
  instance = NULL
)
}
\arguments{
\item{rescale}{character value of "x" or "y". specifies which mapping data will be rescaled}

\item{midpoint}{default set to NULL. Center point about which the rescaled x/y values will reside.}

\item{range}{default set to NULL and auto generates from main mapping range. Specifies the size of the rescaled range.}

\item{location}{specifies where position_rescale should try to place midpoint. If midpoint is specified, location
is ignored and placed at the specified location.}

\item{instance}{integer that indexes rescaled axis calls. instance may be specified and if a previous
layer with the same instance exists, then the same midpoint and range are used for rescaling. x and y are
indexed independently.}
}
\value{
a ggproto object inheriting from 'Position' and can be added to a ggplot
}
\description{
Take the range of the specified axis and rescale it to a new range about a midpoint. By default
the range will be calculated from the associated main plot axis mapping. The range will either be the resolution
or 5\% of the axis range, depending if original data is discrete or continuous respectively. Each layer called
with position_rescale will possess an instance value that indexes with axis rescale. By default, each
position_rescale will dodge the previous call unless instance is specified to a previous layer.
}
\keyword{datasets}
