% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism_shape_pal.R
\name{prism_shape_pal}
\alias{prism_shape_pal}
\title{Prism shape palettes}
\usage{
prism_shape_pal(palette = c("default", "filled", "complete"))
}
\arguments{
\item{palette}{\code{string}. Palette name, one of: \code{default},
\code{filled}, or \code{complete}.}
}
\value{
Returns a function which takes a single integer as its only argument
and returns a character vector of integers which correspond to R plot pch
symbols.
See the examples below for usage.
}
\description{
Shape palettes that approximate those used in GraphPad Prism.
No unicode characters are used, only the default symbols available in R.
}
\details{
The \code{default} palette supports up to 9 values. It does not use
any symbols with a fill.

The \code{filled} palette supports up to 10 values. The first 5 symbols
have a fill.

The \code{complete} palette supports up to 14 values. Symbols 5 to 9
have a fill.
}
\examples{
library(ggplot2)

## list all available shape palettes
ggprism_data$shape_palettes

## select some shapes from a palette
prism_shape_pal(palette = "filled")(4)

## see all the shapes in a specific palette
# define a function for convenience
show_shapes <- function(palette) {
  df_shapes <- ggprism_data$shape_palettes[[palette]][, -1]
  df_shapes$pch_f <- factor(df_shapes$pch, levels = df_shapes$pch)

  ggplot(df_shapes, aes(x = 0, y = 0, shape = pch)) +
    geom_point(aes(shape = pch), size = 5, fill = 'red') +
    scale_shape_identity() +
    facet_wrap(~ pch_f) +
    theme_void()
}

# show the shapes in the palette "complete"
show_shapes("complete")
}
