% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-colour.R, R/zxx.R
\name{scale_colour_discrete}
\alias{scale_colour_discrete}
\alias{scale_fill_discrete}
\alias{scale_color_discrete}
\title{Discrete colour scales}
\usage{
scale_colour_discrete(
  ...,
  palette = NULL,
  aesthetics = "colour",
  na.value = "grey50",
  type = getOption("ggplot2.discrete.colour")
)

scale_fill_discrete(
  ...,
  palette = NULL,
  aesthetics = "fill",
  na.value = "grey50",
  type = getOption("ggplot2.discrete.fill")
)
}
\arguments{
\item{...}{Additional parameters passed on to the scale type,}

\item{palette}{One of the following:
\itemize{
\item \code{NULL} for the default palette stored in the theme.
\item a character vector of colours.
\item a single string naming a palette.
\item a palette function that when called with a single integer argument (the
number of levels in the scale) returns the values that they should take.
}}

\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{na.value}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}

\item{type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} The preferred mechanism for
setting the default palette is by using the theme. For example:
\code{theme(palette.colour.discrete = "Okabe-Ito")}. One of the following:
\itemize{
\item A character vector of color codes. The codes are used for a 'manual' color
scale as long as the number of codes exceeds the number of data levels
(if there are more levels than codes, \code{\link[=scale_colour_hue]{scale_colour_hue()}}/\code{\link[=scale_fill_hue]{scale_fill_hue()}}
are used to construct the default scale). If this is a named vector, then the color values
will be matched to levels based on the names of the vectors. Data values that
don't match will be set as \code{na.value}.
\item A list of character vectors of color codes. The minimum length vector that exceeds the
number of data levels is chosen for the color scaling. This is useful if you
want to change the color palette based on the number of levels.
\item A function that returns a discrete colour/fill scale (e.g., \code{\link[=scale_fill_hue]{scale_fill_hue()}},
\code{\link[=scale_fill_brewer]{scale_fill_brewer()}}, etc).
}}
}
\description{
The default discrete colour scale.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy, colour = class)) +
  geom_point()

# You can use the scale to give a palette directly
p + scale_colour_discrete(palette = scales::pal_brewer(palette = "Dark2"))

# The default colours are encoded into the theme
p + theme(palette.colour.discrete = scales::pal_grey())

# You can globally set default colour palette via the theme
old <- update_theme(palette.colour.discrete = scales::pal_viridis())

# Plot now shows new global default
p

# Restoring the previous theme
theme_set(old)
}
\seealso{
The \href{https://ggplot2-book.org/scales-colour#sec-colour-discrete}{discrete colour scales section} of the online ggplot2 book.
}
