% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_miss.R
\name{plot_miss}
\alias{plot_miss}
\title{Plot missingness in a dataset}
\usage{
plot_miss(
  data,
  vrb = "all",
  ordered = FALSE,
  rotate = FALSE,
  grid = FALSE,
  square = FALSE
)
}
\arguments{
\item{data}{An incomplete dataset of class \code{data.frame} or \code{matrix}.}

\item{vrb}{String, vector, or unquoted expression with variable name(s), default is "all".}

\item{ordered}{Logical indicating whether rows should be ordered according to their pattern.}

\item{rotate}{Logical indicating whether the variable name labels should be rotated 90 degrees.}

\item{grid}{Logical indicating whether borders should be present between tiles.}

\item{square}{Logical indicating whether the plot tiles should be squares, defaults to squares.}
}
\value{
An object of class \link[ggplot2:ggplot]{ggplot2::ggplot}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
# plot correlations for all columns
plot_miss(mice::nhanes)

# plot correlations for specific columns by supplying a character vector
plot_miss(mice::nhanes, c("chl", "hyp"))

# plot correlations for specific columns by supplying unquoted variable names
plot_miss(mice::nhanes, c(chl, hyp))

# plot correlations for specific columns by passing an object with variable names
# from the environment, unquoted with `!!`
my_variables <- c("chl", "hyp")
plot_miss(mice::nhanes, !!my_variables)
# object with variable names must be unquoted with `!!`
try(plot_miss(mice::nhanes, my_variables))

# plot larger dataset
plot_miss(mice::boys)
plot_miss(mice::boys, ordered = TRUE)

}
