% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_blinds}
\alias{theme_blinds}
\title{the theme of blind-like}
\usage{
theme_blinds(colour = c("white", "grey"), axis = "y", ...)
}
\arguments{
\item{colour}{the colour of rectangular, default is c('white', 'grey60').}

\item{axis}{character which grid of axis will be filled, default is 'y'.}

\item{...}{additional parameters that passed to \code{theme} function.}
}
\value{
ggplot2 theme
}
\description{
the theme of blind-like
}
\examples{
library(ggplot2)
iris |> tidyr::pivot_longer(
    cols = !Species,
    names_to = 'var',
    values_to = 'value'
  ) |>
ggplot(
  aes(x=var, y=Species, color=value, size=value)
) +
geom_point() -> p
p +
theme_blinds(
  colour = c('grey90', 'white'),
  axis = 'y',
  axis.line.y=element_line()
)
p +
theme_blinds(
  colour = c('grey90', 'white'),
  axis = 'x',
  axis.line.x = element_line()
)
}
