% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_cluster.R
\name{autoplot.silhouette}
\alias{autoplot.silhouette}
\title{Autoplot silhouette instances}
\usage{
\method{autoplot}{silhouette}(
  object,
  colour = "red",
  linetype = "dashed",
  size = 0.5,
  bar.width = 1,
  ...
)
}
\arguments{
\item{object}{Silhouette instance}

\item{colour}{reference line color}

\item{linetype}{reference line type}

\item{size}{reference line size}

\item{bar.width}{bar width}

\item{...}{other arguments passed to methods}
}
\value{
ggplot
}
\description{
Autoplot silhouette instances
}
\examples{
\dontrun{
model = cluster::pam(iris[-5], 3L)
sil = cluster::silhouette(model)
autoplot(sil)

autoplot(cluster::silhouette(cluster::clara(iris[-5], 3)))
autoplot(cluster::silhouette(cluster::fanny(iris[-5], 3)))

model = stats::kmeans(iris[-5], 3)
sil = cluster::silhouette(model$cluster, stats::dist(iris[-5]))
autoplot(sil)
}
}
