% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/model_checks.R
\name{is_core_parameter_x_condition}
\alias{is_core_parameter_x_condition}
\alias{is_parameter_x_condition}
\alias{get_stimulus_level_r}
\alias{get_factor_cells_r}
\alias{parameter_mapping_functions}
\title{Parameter Mapping and Condition Processing Utilities}
\usage{
is_core_parameter_x_condition(parameter_map_r, factors_r)

is_parameter_x_condition(parameter_map_r, factors_r)

get_stimulus_level_r(parameter_map_r, factors_r, accumulators_r)

get_factor_cells_r(parameter_map_r, factors_r, accumulators_r)
}
\arguments{
\item{parameter_map_r}{A named list mapping parameters to conditions and factors.
       Example structure:
       \code{list(A = "1", B = "1", t0 = "1", mean_v = "M", sd_v = "1", st0 = "1")}
       Where:
       \itemize{
         \item '1' indicates this parameter is constant across conditions
         \item "M" indicates this parameter is associated with the internal
matching factor. It changes depends on whether it is a match (i.e., correct)
response or a mismatched (i.e., incorrect) response.
         \item Other strings indicate factor dependencies
       }}

\item{factors_r}{A named list of experimental factors and their levels.
Example: \code{list(S = c("red", "blue"))}}

\item{accumulators_r}{A character vector of accumulator names.
Example: \code{c("r1", "r2")}}
}
\value{
\describe{
  \item{is_core_parameter_x_condition}{Logical vector indicating whether 
core parameters (before associating with any conditions) are factor-dependent}
  \item{is_parameter_x_condition}{Logical vector indicating whether 
parameters are factor-dependent}
  \item{get_stimulus_level_r}{Character vector of stimulus levels for each 
accumulator}
  \item{get_factor_cells_r}{List of factor combinations for each accumulator}
}
}
\description{
A set of helper functions for processing parameter mappings across
experimental conditions. These functions are used internally for
building the model Boolean array.
}
\details{
These functions work together to:
\itemize{
  \item Analyse parameter mappings across experimental conditions
  \item Identify which parameters vary by conditions
  \item Generate appropriate stimulus levels and factor combinations
}
}
\examples{
p_map <- list(A = "1", B = "1", t0 = "1", mean_v = "M", sd_v = "1", st0 = "1")
factors <- list(S = c("red", "blue"))
accumulators <- c("r1", "r2")

# Check which parameters are core (not condition-dependent)
is_core_parameter_x_condition(p_map, factors)

# Get stimulus levels for each accumulator
get_stimulus_level_r(p_map, factors, accumulators)
}
