% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{BuildDMI}
\alias{BuildDMI}
\title{Build Data Model Instance}
\usage{
BuildDMI(data, model)
}
\arguments{
\item{data}{A data frame to be converted to a DMI object.}

\item{model}{A model specification object of class \code{model} containing
parameters, and other model-specific information. This is typically
created using the `BuildModel` function.}
}
\value{
A 'dmi' object or a list of 'dmi' objects (multiple subjects),
with structure:
\itemize{
  \item For choice RT models: Returns a named list of 'dmi' objects
        (one per subject)
  \item For hyperparameter models: Returns a single 'dmi' object
}
Each 'dmi' object contains:
\itemize{
  \item 'model' - The model specification
  \item 'data' - The processed data (a list)
  \item 'node_1_index` - Index mapping for first nodes (LBA only)
  \item 'is_positive_drift` - A logical vector indicating drift
directions. For the LBA model, each element corresponds to an
accumulator. For the DDM, each element represents a condition.
In the DDM, a positive drift direction corresponds to a correct
response (i.e., the accumulator reaches the upper bound), and vice versa.
}
}
\description{
Constructs a Data Model Instance (DMI) from data and model
specifications. The DMI builder can handle different model types including
the Linear Ballistic Accumulator, the Diffusion Decision and hyperparameter.
The process of building a 'hyperparameter' DMI amounts to constructing a
joint distribution over conventional statistical models.
}
\section{Model Types Supported}{

\describe{
  \item{`"lba"`}{Linear Ballistic Accumulator model}
  \item{`"hyper"`}{Hyperparameter model}
  \item{`"fastdm"`}{Diffusion Decision model}
}
}

\examples{
# Hyperparameter model example
hyper_model <- BuildModel(
    p_map = list(A = "1", B = "1", mean_v = "M", sd_v = "1", st0 = "1", t0 = "1"),
    match_map = list(M = list(s1 = "r1", s2 = "r2")),
    factors = list(S = c("s1", "s2")),
    constants = c(sd_v = 1, st0 = 0),
    accumulators = c("r1", "r2"),
    type = "hyper",
    verbose = FALSE
)

# LBA model example
model <- BuildModel(
    p_map = list(A = "1", B = "1", t0 = "1", mean_v = "M", sd_v = "1", st0 = "1"),
    match_map = list(M = list(s1 = "r1", s2 = "r2")),
    factors = list(S = c("s1", "s2")),
    constants = c(st0 = 0, sd_v = 1),
    accumulators = c("r1", "r2"),
    type = "lba"
)

dat <- data.frame(
  RT = c(0.7802726, 0.7890208, 1.3222672, 0.8376305, 0.7144698),
  R  = c("r1", "r1", "r2", "r1", "r1"),
  s  = c(1, 1, 1, 1, 1),
  S  = c("s1", "s1", "s1", "s1", "s1"),
  stringsAsFactors = FALSE
)

sub_dmis <- BuildDMI(dat, model)

}
