% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center_matrix.R
\name{center_matrix}
\alias{center_matrix}
\title{helper function to center a numeric matrix within a (larger) target matrix size}
\usage{
center_matrix(output_dim, mat, default_value = NA_real_, drop_zeros = TRUE)
}
\arguments{
\item{output_dim}{the desired dimensions of the output matrix}

\item{mat}{the 2D numeric matrix containing values to be centered in the output matrix}

\item{default_value}{the value that should fill padded rows and columns of the output matrix}

\item{drop_zeros}{if TRUE, all zero-valued rows and columns of \code{mat} will be dropped before
the data are centered within the output matrix. This is useful if the matrix is asymmetric,
but you still want to have it be dead-center in the output.}
}
\value{
an expanded matrix of size \code{output_dim} with the input matrix \code{mat} centered
within it.
}
\description{
helper function to center a numeric matrix within a (larger) target matrix size
}
\keyword{internal}
