% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-operation-product.R, R/operation-.R,
%   R/operation-adjust.R, R/operation-nop.R, R/operation-product.R
\docType{class}
\name{operation_product}
\alias{operation_product}
\alias{operation_product-class}
\alias{*,operation,ANY-method}
\alias{*,ANY,operation-method}
\alias{*,adjust,adjust-method}
\alias{*,nop,nop-method}
\alias{*,operation,nop-method}
\alias{*,operation_sum,nop-method}
\alias{*,nop,operation-method}
\alias{*,nop,operation_sum-method}
\alias{prod,operation-method}
\alias{*,operation,operation-method}
\alias{*,numeric,operation-method}
\alias{*,operation,numeric-method}
\alias{*,operation,operation_sum-method}
\alias{*,operation_sum,operation-method}
\alias{*,operation_sum,operation_sum-method}
\title{Layer operation products}
\usage{
\S4method{*}{operation,ANY}(e1, e2)

\S4method{*}{ANY,operation}(e1, e2)

\S4method{*}{adjust,adjust}(e1, e2)

\S4method{*}{nop,nop}(e1, e2)

\S4method{*}{operation,nop}(e1, e2)

\S4method{*}{operation_sum,nop}(e1, e2)

\S4method{*}{nop,operation}(e1, e2)

\S4method{*}{nop,operation_sum}(e1, e2)

\S4method{prod}{operation}(x, ..., na.rm = FALSE)

\S4method{*}{operation,operation}(e1, e2)

\S4method{*}{numeric,operation}(e1, e2)

\S4method{*}{operation,numeric}(e1, e2)

\S4method{*}{operation,operation_sum}(e1, e2)

\S4method{*}{operation_sum,operation}(e1, e2)

\S4method{*}{operation_sum,operation_sum}(e1, e2)
}
\arguments{
\item{e1}{an \link{operation}, \link{layer-like}, or \code{\link[=numeric]{numeric()}}}

\item{e2}{an \link{operation}, \link{layer-like}, or \code{\link[=numeric]{numeric()}}}

\item{x, ...}{\link{operation}s}

\item{na.rm}{ignored}
}
\value{
An \link{operation}.
}
\description{
\link{operation}s can be multiplied together to form chains of operations, which
when multiplied by (applied to) \link{layer-like} objects, return modified \link{layer-like} objects.
}
\details{
Multiplication of \pkg{ggblend} \link{operation}s depends on the types of
objects being multiplied:
\itemize{
\item If you multiply an \link{operation} with an \link{operation}, they are merged into
a single \link{operation} that applies each \link{operation} in sequence.
\item If you multiply an \link{operation} with a \link{layer-like} object, that operation is applied
to the layer, returning a new \link{layer-like} object.
\item If you multiply an \link{operation} by a \code{\link[=numeric]{numeric()}} \emph{n}, a new \link{operation} that
repeats the input \link{operation} is \emph{n} times is returned.
}
}
\examples{
library(ggplot2)

# multiplying operations by numerics repeats them...
adjust(color = "red") * 2

# multiplying operations together chains (or merges) them
adjust(color = "red") * adjust(linewidth = 2)

# multiplication obeys the distributive law
op = (adjust(aes(y = 11 -x), color = "skyblue") + 1) * (adjust(color = "white", linewidth = 4) + 1)
op

# multiplication by a geom returns a modified version of that geom
data.frame(x = 1:10) |>
  ggplot(aes(x = x, y = x)) +
  geom_line(linewidth = 2) * op

}
