% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-operation-.R, R/operation-.R,
%   R/operation-adjust.R, R/operation-affine-transform.R, R/operation-blend.R,
%   R/operation-composition.R, R/operation-nop.R, R/operation-product.R
\docType{class}
\name{operation-class}
\alias{operation-class}
\alias{operation}
\alias{show,operation-method}
\alias{format,operation-method}
\alias{format,adjust-method}
\alias{format,affine_transform-method}
\alias{format,blend-method}
\alias{format,operation_composition-method}
\alias{format,nop-method}
\alias{format,operation_product-method}
\title{Layer operations}
\usage{
\S4method{show}{operation}(object)

\S4method{format}{operation}(x, ...)

\S4method{format}{adjust}(x, ...)

\S4method{format}{affine_transform}(x, ...)

\S4method{format}{blend}(x, ...)

\S4method{format}{operation_composition}(x, ...)

\S4method{format}{nop}(x, ...)

\S4method{format}{operation_product}(x, ...)
}
\arguments{
\item{x, object}{An \link{operation}.}

\item{...}{Further arguments passed to other methods.}
}
\value{
For \code{show()}, an \code{\link[=invisible]{invisible()}} copy of the input.

For \code{format()}, a character string representing the input.
}
\description{
Layer \link{operation}s are composable transformations that can be applied to \pkg{ggplot2}
\link{layer-like} objects, such as \code{stat}s, \code{geom}s, and lists of \code{stat}s and
\code{geom}s; see the \link{layer-like} documentation page for a description of valid
\link{layer-like} objects.
}
\details{
\link{operation}s can be composed using the \code{+} and \code{*} operators (see \link{operation_sum}
and \link{operation_product}). Addition and multiplication of \link{operation}s and \link{layer-like}
objects obeys the distributive law.

\link{operation}s can be applied to \link{layer-like} objects using \code{*} or \verb{|>}, with slightly
different results:
\itemize{
\item Using \code{*}, application of \link{operation}s to a list of \link{layer-like} objects \emph{is} distributive. For example,
\code{list(geom_line(), geom_point()) * blend("multiply")} is
equivalent to \code{list(geom_line() * blend("multiply"), geom_point() * blend("multiply"))};
i.e. it multiply-blends the contents of the two layers individually.
\item Using \verb{|>}, application of \link{operation}s to a list of \link{layer-like} objects is \emph{not}
distributive (unless the only reasonable interpretation of applying the
transformation is necessarily distributive; e.g. \code{adjust()}). For example,
\code{list(geom_line(), geom_point()) |> blend("multiply")} would multiply-blend
both layers together, rather than multiply-blending the contents of the
two layers individually.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(operation)}: Print an \link{operation}.

\item \code{format(operation)}: Format an \link{operation} for printing.

}}
\examples{
library(ggplot2)

# operations can stand alone
adjust(aes(color = x))

# they can also be applied to layers through multiplication or piping
geom_line() |> adjust(aes(color = x))
geom_line() * adjust(aes(color = x))

# layer operations act as a small algebra, and can be combined through
# multiplication and addition
(adjust(fill = "green") + 1) * blend("multiply")

}
