% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheme-align.R
\name{scheme_align}
\alias{scheme_align}
\title{Align Specifications in the Layout}
\usage{
scheme_align(guides = NA, free_spaces = NA, free_labs = NA)
}
\arguments{
\item{guides}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, \code{"r"}, and \code{"i"}
indicating which side of guide legends should be collected. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If no
parent layout, all guides will be collected. If \code{NULL}, no guides will be
collected.}

\item{free_spaces}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"}
indicating which border spaces should be removed. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If no
parent, the default is \code{NULL}, meaning no spaces are removed.

Usually you want to apply this with the whole layout, instead of individual
plots.}

\item{free_labs}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"}
indicating which axis titles should be free from alignment. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If no
parent layout, no axis titles will be aligned. If \code{NULL}, all axis titles
will be aligned.}
}
\value{
A \code{scheme_align} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{scheme_align()} function defines the align Specifications for plots.
}
\examples{
set.seed(123)
mat <- matrix(rnorm(72), nrow = 8)
# used in the layout, define the default action for all plots in the layout
ggheatmap(mat) -
    scheme_align(guides = NULL) +
    anno_right() +
    align_dendro(aes(color = branch), k = 3)

# You can also add it for a single plot
ggheatmap(mat) -
    # for all plots in the layout, we default won't collect any guide legends
    scheme_align(guides = NULL) +
    # for the heatmap body, we collect guide legends in the right
    # note, the guide legends will be collected to the right side of the
    # layout which will overlap the legends in the right annotation
    scheme_align(guides = "r") +
    anno_right() +
    align_dendro(aes(color = branch), k = 3)

# to avoid overlapping, we can also collect the guide legends in the
# right annotation
ggheatmap(mat) -
    scheme_align(guides = NULL) +
    scheme_align(guides = "r") +
    anno_right() +
    align_dendro(aes(color = branch), k = 3) +
    scheme_align(guides = "r")
}
