% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_methylation_from_fastq.R
\name{write_modified_fastq}
\alias{write_modified_fastq}
\title{Write modification information stored in dataframe back to modified FASTQ}
\usage{
write_modified_fastq(
  dataframe,
  filename = NA,
  read_id_colname = "read",
  sequence_colname = "sequence",
  quality_colname = "quality",
  locations_colnames = c("hydroxymethylation_locations", "methylation_locations"),
  probabilities_colnames = c("hydroxymethylation_probabilities",
    "methylation_probabilities"),
  modification_prefixes = c("C+h?", "C+m?"),
  include_blank_tags = TRUE,
  return = FALSE
)
}
\arguments{
\item{dataframe}{\code{dataframe}. Dataframe containing modification information to write back to modified FASTQ. Must have columns for unique read ID, DNA sequence, and at least one set of locations and probabilities for a particular modification type (e.g. 5C methylation).}

\item{filename}{\code{character}. File to write the modified FASTQ to. Recommended to end with \code{.fastq} (warns but works if not). If set to \code{NA} (default), no file will be output, which may be useful for testing/debugging.}

\item{read_id_colname}{\code{character}. The name of the column within the dataframe that contains the unique ID for each read. Defaults to \code{"read"}.}

\item{sequence_colname}{\code{character}. The name of the column within the dataframe that contains the DNA sequence for each read. Defaults to \code{"sequence"}.\cr\cr The values within this column must be DNA sequences e.g. \code{"GGCGGC"}.}

\item{quality_colname}{\code{character}. The name of the column within the dataframe that contains the FASTQ quality scores for each read. Defaults to \code{"quality"}. If scores are not known, can be set to \code{NA} to fill in quality with \code{"B"}.\cr\cr If not \code{NA}, must correspond to a column where the values are the FASTQ quality scores e.g. \verb{"$12\\">/2C;4:9F8:816E,6C3*,"} - see \code{\link{fastq_quality_scores}}.}

\item{locations_colnames}{\verb{character vector}. Vector of the names of all columns within the dataframe that contain modification locations. Defaults to \code{c("hydroxymethylation_locations", "methylation_locations")}.\cr\cr The values within these columns must be comma-separated strings of indices at which modification was assessed, as produced by \code{\link[=vector_to_string]{vector_to_string()}}, e.g. \code{"3,6,9,12"}.\cr\cr Will fail if these locations are not instances of the target base (e.g. \code{"C"} for \code{"C+m?"}), as the SAMtools tag system does not work otherwise. One consequence of this is that if sequences have been reversed via \code{\link[=merge_methylation_with_metadata]{merge_methylation_with_metadata()}} or helpers, they cannot be written to FASTQ \emph{unless} modification locations are symmetric e.g. CpG \emph{and} offset was set to \code{1} when reversing (see \code{\link[=reverse_locations_if_needed]{reverse_locations_if_needed()}}).}

\item{probabilities_colnames}{\verb{character vector}. Vector of the names of all columns within the dataframe that contain modification probabilities. Defaults to \code{c("hydroxymethylation_probabilities", "methylation_probabilities")}.\cr\cr The values within the columns must be comma-separated strings of modification probabilities, as produced by \code{\link[=vector_to_string]{vector_to_string()}}, e.g. \code{"0,255,128,78"}.}

\item{modification_prefixes}{\verb{character vector}. Vector of the prefixes to be used for the MM tags specifying modification type. These are usually generated by Dorado/Guppy based on the original modified basecalling settings, and more details can be found in the SAM optional tag specifications. Defaults to \code{c("C+h?", "C+m?")}.\cr\cr \code{locations_colnames}, \code{probabilities_colnames}, and \code{modification_prefixes} must all have the same length e.g. 2 if there were 2 modification types assessed.}

\item{include_blank_tags}{\code{logical}. Boolean specifying what to do if a particular read has no assessed locations for a given modification type from \code{modification_prefixes}.\cr\cr If \code{TRUE} (default), blank tags will be written e.g. \code{"C+h?;"} (whereas a normal, non-blank tag looks like \code{"C+h?,0,0,0,0;"}). If \code{FALSE}, tags with no assessed locations in that read will not be written at all.}

\item{return}{\code{logical}. Boolean specifying whether this function should return the FASTQ (as a character vector of each line in the FASTQ), otherwise it will return \code{invisible(NULL)}. Defaults to \code{FALSE}.}
}
\value{
\verb{character vector}. The resulting modified FASTQ file as a character vector of its constituent lines (or \code{invisible(NULL)} if \code{return} is \code{FALSE}). This is probably mostly useful for debugging, as setting \code{filename} within this function directly writes to FASTQ via \code{\link[=writeLines]{writeLines()}}. Therefore, defaults to returning \code{invisible(NULL)}.
}
\description{
This function takes a dataframe containing DNA modification information
(e.g. produced by \code{\link[=read_modified_fastq]{read_modified_fastq()}}) and writes it back to modified
FASTQ, equivalent to what would be produced via \verb{samtools fastq -T MM,ML}.\cr\cr
Arguments give the names of columns within the dataframe from which to read.\cr\cr
If multiple types of modification have been assessed (e.g. both methylation
and hydroxymethylation), then multiple colnames must be provided for locations
and probabilites, and multiple prefixes (e.g. \code{"C+h?"}) must be provided.
\strong{IMPORTANT:} These three vectors must all be the same length, and the modification
types must be in a consistent order (e.g. if writing hydroxymethylation and methylation
in that order, must do H then M in all three vectors and never vice versa).\cr\cr
If quality isn't known (e.g. there was a FASTA step at some point in the pipeline),
the \code{quality} argument can be set to \code{NA} to fill in quality scores with \code{"B"}. This
is the same behaviour as SAMtools v1.21 when converting FASTA to SAM/BAM then FASTQ.
I don't really know why SAMtools decided the default quality should be "B" but there
was probably a reason so I have stuck with that.\cr\cr
Default arguments are set up to work with the included \code{\link{example_many_sequences}} data.
}
\examples{
## Write to FASTQ (using filename = NA, return = FALSE
## to view as char vector rather than writing to file)
write_modified_fastq(
    example_many_sequences,
    filename = NA,
    read_id_colname = "read",
    sequence_colname = "sequence",
    quality_colname = "quality",
    locations_colnames = c("hydroxymethylation_locations",
                           "methylation_locations"),
    probabilities_colnames = c("hydroxymethylation_probabilities",
                               "methylation_probabilities"),
    modification_prefixes = c("C+h?", "C+m?"),
    return = TRUE
)

## Write methylation only, and fill in qualities with "B"
write_modified_fastq(
    example_many_sequences,
    filename = NA,
    read_id_colname = "read",
    sequence_colname = "sequence",
    quality_colname = NA,
    locations_colnames = c("methylation_locations"),
    probabilities_colnames = c("methylation_probabilities"),
    modification_prefixes = c("C+m?"),
    return = TRUE
)

}
