% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_with_metadata.R
\name{reverse_probabilities_if_needed}
\alias{reverse_probabilities_if_needed}
\title{Reverse modification probabilities if needed (\code{\link[=merge_methylation_with_metadata]{merge_methylation_with_metadata()}} helper)}
\usage{
reverse_probabilities_if_needed(probabilities_vector, direction_vector)
}
\arguments{
\item{probabilities_vector}{\verb{character vector}. The probabilities to be reversed for each sequence/read. Each read should have one character value, representing a comma-separated list of the modification probabilities for each assessed base along the read e.g. \code{"230,7,64,145"}. In most situations these will be 8-bit integers from 0 to 255, but this function will work on any comma-separated values.\cr\cr These comma-separated characters/strings can be produced from numeric vectors via \code{\link[=vector_to_string]{vector_to_string()}} and converted back to vectors via \code{\link[=string_to_vector]{string_to_vector()}}.}

\item{direction_vector}{\verb{character vector}. Whether each sequence is forward or reverse. Must contain only \code{"forward"} and \code{"reverse"}, but is not case sensitive. Must be the same length as \code{probabilities_vector}.}
}
\value{
\verb{character vector}. A vector of all forward versions of the input probabilities vector.
}
\description{
This function takes a vector of condensed modification probabilities
(e.g. \verb{c("128,0,63,255", "3,78,1"}) and a vector of directions (which
must all be either \code{"forward"} or \code{"reverse"}, \emph{not} case-sensitive),
and returns a vector of condensed modification probabilities where those
that were originally forward are unchanged, and those that were originally
reverse are flipped to now be forward.\cr\cr
Called by \code{\link[=merge_methylation_with_metadata]{merge_methylation_with_metadata()}} to create a forward dataset, alongside
\code{\link[=reverse_sequence_if_needed]{reverse_sequence_if_needed()}}, \code{\link[=reverse_quality_if_needed]{reverse_quality_if_needed()}}, and \code{\link[=reverse_locations_if_needed]{reverse_locations_if_needed()}}.\cr\cr
}
\examples{
reverse_probabilities_if_needed(
    probabilities_vector = c("100,200,50", "100,200,50"),
    direction_vector = c("forward", "reverse")
)

}
