% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_methylation_from_fastq.R
\name{read_modified_fastq}
\alias{read_modified_fastq}
\title{Read modification information from modified FASTQ}
\usage{
read_modified_fastq(filename = file.choose(), debug = FALSE)
}
\arguments{
\item{filename}{\code{character}. The file to be read. Defaults to \code{\link[=file.choose]{file.choose()}} to select a file interactively.}

\item{debug}{\code{logical}. Boolean value for whether the extra \verb{<MM/ML>_tags} and \verb{<MM/ML>_raw} columns should be added to the dataframe. Defaults to \code{FALSE} as I can't imagine this is often helpful, but the option is provided to assist with debugging.}
}
\value{
\code{dataframe}. Dataframe of modification information, as described above.\cr\cr Sequences can be visualised with \code{\link[=visualise_many_sequences]{visualise_many_sequences()}} and modification information can be visualised with \code{\link[=visualise_methylation]{visualise_methylation()}} (despite the name, any type of information can be visualised as long as it has locations and probabilities columns).\cr\cr Can be written back to FASTQ via \code{\link[=write_modified_fastq]{write_modified_fastq()}}.
}
\description{
This function reads a modified FASTQ file (e.g. created by \verb{samtools fastq -T MM,ML}
from a BAM basecalled with a modification-capable model in Dorado or Guppy) to a dataframe.\cr\cr
By default, the dataframe contains columns for unique read id (\code{read}), sequence (\code{sequence}),
sequence length (\code{sequence_length}), quality (\code{quality}), comma-separated (via \code{\link[=vector_to_string]{vector_to_string()}})
modification types present in each read (\code{modification_types}), and for each modification type,
a column of comma-separated modification locations (\verb{<type>_locations}) and
a column of comma-separated modification probabilities (\verb{<type>_probabilities}).\cr\cr
Modification locations are the indices along the read at which modification was assessed
e.g. a 3 indicates that the third base in the read was assessed for modifications of the given type.
Modification probabilities are the probability that the given modification is present, given as
an integer from 0-255 where integer \eqn{N} represents the probability space from \eqn{\frac{N}{256}}
to \eqn{\frac{N+1}{256}}.\cr\cr
To extract the numbers from these columns as numeric vectors to analyse, use \code{\link[=string_to_vector]{string_to_vector()}} e.g.
\code{list_of_locations <- lapply(test_01$`C+h?_locations`, string_to_vector)}. Be aware that the SAM
modification types often contain special characters, meaning the colname may need to be enclosed in
backticks as in this example. Alternatively, use \code{\link[=extract_methylation_from_dataframe]{extract_methylation_from_dataframe()}} to
create a list of locations, probabilities, and lengths ready for visualisation in
\code{\link[=visualise_methylation]{visualise_methylation()}}. This works with any modification type extracted in this function,
just provide the relevant colname when calling \code{\link[=extract_methylation_from_dataframe]{extract_methylation_from_dataframe()}}.\cr\cr
Optionally (by specifying \code{debug = TRUE}), the dataframe will also contain columns of
the raw MM and ML tags (\verb{<MM/ML>_raw}) and of the same tags with the initial label
trimmed out (\verb{<MM/ML>_tags}). This is not recommended in most situations but may help
with debugging unexpected issues as it contains the raw data exactly from the FASTQ.\cr\cr
Dataframes produced by this function can be written back to modified FASTQ via \code{\link[=write_modified_fastq]{write_modified_fastq()}}.
}
\examples{
## Locate file
modified_fastq_file <- system.file("extdata",
                                   "example_many_sequences_raw_modified.fastq",
                                   package = "ggDNAvis")

## View file
for (i in 1:16) {
    cat(readLines(modified_fastq_file)[i], "\n")
}

## Read file to dataframe
read_modified_fastq(modified_fastq_file, debug = FALSE)
read_modified_fastq(modified_fastq_file, debug = TRUE)

}
