% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-visualization.R
\name{plot_raster_fast}
\alias{plot_raster_fast}
\title{Create fast raster plot using terra}
\usage{
plot_raster_fast(
  raster_data,
  title = "Raster Plot",
  color_scheme = "viridis",
  region_boundary = NULL,
  breaks = NULL,
  output_file = NULL,
  verbose = FALSE
)
}
\arguments{
\item{raster_data}{SpatRaster to plot or file path}

\item{title}{Plot title}

\item{color_scheme}{Color scheme to apply}

\item{region_boundary}{Optional boundary to overlay}

\item{breaks}{Custom breaks for classification}

\item{output_file}{Optional output file path}

\item{verbose}{Print progress messages}
}
\value{
NULL (plots directly to device) or file path if saved
}
\description{
Create efficient raster plots using terra's native plotting capabilities.
Fast and reliable without external dependencies.
}
\examples{
\dontrun{
# These examples demonstrate workflows with user's own spatial data
# Simple raster plot
plot_raster_fast(ndvi_raster, "NDVI Analysis", "ndvi")

# With custom breaks and save to file
plot_raster_fast(elevation, "Elevation", "terrain",
                breaks = c(0, 500, 1000, 1500, 2000),
                output_file = "elevation_map.png")
}

}
