% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/definir_campos.R
\name{definir_campos}
\alias{definir_campos}
\title{Especifica as colunas que descrevem os campos dos endereços}
\usage{
definir_campos(
  estado,
  municipio,
  logradouro = NULL,
  numero = NULL,
  cep = NULL,
  localidade = NULL
)
}
\arguments{
\item{estado}{Uma string. O nome da coluna que representa o estado do
endereço. Campo obrigatório. Na tabela de endereços, essa coluna pode
conter os nomes dos estados por extenso, ou a abrevição oficial dos estados
com duas letras, e.g. "AM", "SP", "DF", "RJ".}

\item{municipio}{Uma string. O nome da coluna que representa o município do
endereço. Campo obrigatório. Na tabela de endereços, essa coluna pode
conter o nome dos municípios, ou o seu código IBGE de 7 dígitos.}

\item{logradouro}{Uma string. O nome da coluna que representa o \emph{logradouro}
(endereço da rua) do endereço. Pode ser \code{NULL} se o campo não estiver
especificado na tabela de endereços. Na tabela de endereços, essa coluna
deve incluir o \emph{tipo} do lograoduro, indicando se trata-se de uma "Rua" ou
"Avenida" etc, por exemplo "Avenida Presidente Getúlio Vargas". Além disso,
essa coluna \emph{não} deve incluir o \code{numero} do endereço, pois o número deve
ser indicado numa coluna separada.}

\item{numero}{Uma string. O nome da coluna que representa o número do endereço.
Pode ser \code{NULL} se o campo não estiver especificado na tabela de endereços.
Na tabela de endereços, valores como \code{0} ou caracteres não numerciso como
\code{"S/N"} ou \code{"10a"} são considerados como \code{NA}.}

\item{cep}{Uma string. O nome da coluna que representa o \emph{CEP} (Código de
Endereçamento Postal) do endereço. Pode ser \code{NULL} se o campo não estiver
especificado na tabela de endereços.}

\item{localidade}{Uma string. O nome da coluna que representa a localidade
(equivalente ao 'bairro' em áreas urbanas) do endereço. Pode ser \code{NULL} se
esse campo não estiver presente na tabela de endereços.}
}
\value{
Um vetor de caracteres no qual os nomes são os campos do endereço e os
valores são as colunas que os representam na tabela de endereços.
}
\description{
Cria um vetor de caracteres especificando as colunas que representam cada
campo do endereço na tabela de endereços. Os campos \code{estado} e \code{municipio}
são obrigatórios.
}
\examples{
definir_campos(
  logradouro = "Nome_logradouro",
  numero = "Numero",
  cep = "CEP",
  localidade = "Bairro",
  municipio = "Cidade",
  estado = "UF"
)

}
