% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers_optim.R
\name{wrappers_optim}
\alias{wrappers_optim}
\alias{wrapper_optim_stats}
\alias{wrapper_optim_nloptr}
\title{Wrappers for Optimization Functions}
\usage{
wrapper_optim_stats(
  obj_fun,
  theta_start,
  theta_bound_lower,
  theta_bound_upper,
  est_details,
  ...
)

wrapper_optim_nloptr(
  obj_fun,
  theta_start,
  theta_bound_lower,
  theta_bound_upper,
  est_details,
  ...
)
}
\arguments{
\item{obj_fun}{An objective function.}

\item{theta_start}{A numeric vector of starting values of the variables.}

\item{theta_bound_lower}{A numeric vector of lower bounds on the variables.}

\item{theta_bound_upper}{A numeric vector of upper bounds on the variables.}

\item{est_details}{A list of variables used for estimation.}

\item{...}{Additional arguments to be passed to the optimization function.}
}
\value{
A list with components:
  \item{status_optim}{The status of the optimization computation.}
  \item{theta_optim}{The optimal solution.}
}
\description{
Wrappers of common R optimization functions.
Their purpose is to be passed as the \code{optim_function} argument in the \code{\link[gasmodel:gas]{gas()}} function.
}
\section{Functions}{
\itemize{
\item \code{wrapper_optim_stats()}: Wrapper for optimization function \code{\link[stats:optim]{stats::optim()}}.

\item \code{wrapper_optim_nloptr()}: Wrapper for optimization function \code{\link[nloptr:nloptr]{nloptr::nloptr()}}.

}}
\seealso{
\code{\link[gasmodel:gas]{gas()}}
\code{\link[gasmodel:wrappers_hessian]{wrappers_hessian}}
\code{\link[gasmodel:wrappers_parallel]{wrappers_parallel}}
}
