% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{combo_options}
\alias{combo_options}
\title{Create Combo Options Configuration for G6 Graphs}
\usage{
combo_options(
  type = "circle",
  style = NULL,
  state = NULL,
  palette = NULL,
  animation = NULL
)
}
\arguments{
\item{type}{Combo type. Can be a built-in combo type name or a custom combo name.
Built-in types include "circle", "rect", "polygon", etc. Default: "circle".}

\item{style}{Combo style configuration. Controls the appearance of combos including color,
size, border, etc.
Default: NULL.}

\item{state}{Defines the style of the combo in different states, such as hover, selected,
disabled, etc. Should be a list mapping state names to style configurations.
Default: NULL.}

\item{palette}{Defines the color palette of the combo, used to map colors based on different data.
Default: NULL.}

\item{animation}{Defines the animation effect of the combo. Can be created with
\code{animation_config()}.
Default: NULL.}
}
\value{
A list containing combo options configuration that can be passed to \code{\link[=g6_options]{g6_options()}}.
}
\description{
Configures the general options for combos in a G6 graph. These settings control
the type, style, state, palette, and animation of combos.
}
\details{
Combo options allow defining how combos (node groupings) appear and behave in a G6 graph.
This includes selecting combo types, setting styles, configuring state-based appearances,
defining color palettes, and specifying animation effects.
}
\examples{
# Basic combo options with default circle type
options <- combo_options()

# Rectangle combo with custom style
options <- combo_options(
  type = "rect",
  style = list(
    fill = "#F6F6F6",
    stroke = "#CCCCCC",
    lineWidth = 1
  )
)
}
