% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{brush_select}
\alias{brush_select}
\title{Configure Brush Selection Interaction}
\usage{
brush_select(
  key = "brush-select",
  animation = FALSE,
  enable = JS("(e) => {\\n      return true\\n    }"),
  enableElements = "node",
  immediately = FALSE,
  mode = c("default", "union", "intersect", "diff"),
  onSelect = NULL,
  state = c("selected", "active", "inactive", "disabled", "highlight"),
  style = NULL,
  trigger = "shift",
  ...
)
}
\arguments{
\item{key}{Behavior unique identifier. Useful to modify this behavior from JS side.}

\item{animation}{Whether to enable animation (boolean, default: FALSE).}

\item{enable}{Whether to enable brush select functionality (boolean or function, default: TRUE).}

\item{enableElements}{Types of elements that can be selected (character vector, default: "node").
Can be \code{c("node", "edge", "combo")}.}

\item{immediately}{Whether to select immediately in default mode (boolean, default: FALSE).}

\item{mode}{Selection mode: "union", "intersect", "diff", or "default" (string, default: "default").}

\item{onSelect}{Callback for selected element state (JS function).}

\item{state}{State to switch to when selected (string, default: "selected").}

\item{style}{Style specification for the selection box (list).
See \url{https://g6.antv.antgroup.com/en/manual/behavior/brush-select#style}.}

\item{trigger}{Shortcut keys for selection (character vector).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/brush-select}.}
}
\value{
A list with the configuration settings for the brush select behavior.
}
\description{
Creates a configuration object for brush selection interaction in graph visualizations.
This function configures how elements are selected when using a brush selection tool.
}
\examples{
# Basic configuration
config <- brush_select()

# Custom configuration
config <- brush_select(
  animation = TRUE,
  enableElements = c("node", "edge"),
  mode = "union",
  state = "highlight",
  style = list(
    fill = "rgba(0, 0, 255, 0.1)",
    stroke = "blue",
    lineWidth = 2
  ),
  trigger = c("Shift")
)
}
