% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_w.R
\docType{class}
\name{FuzzUtils}
\alias{FuzzUtils}
\title{Utility functions}
\usage{
# init <- FuzzUtils$new()
}
\description{
Utility functions

Utility functions
}
\details{
the \emph{decoding} parameter is useful in case of non-ascii character strings. If this parameter is not NULL then the \emph{force_ascii} parameter (if applicable) is internally set to FALSE. Decoding applies only to python 2 configurations, as in python 3 character strings are decoded to unicode by default.

the \emph{Full_process} processes a string by : 1. removing all but letters and numbers, 2. trim whitespace, 3. force to lower case and 4. if force_ascii == TRUE, force convert to ascii

the \emph{INTR} method returns a correctly rounded integer

the \emph{Make_type_consistent} method converts both objects if they aren't either both string or unicode instances to unicode

the \emph{Asciidammit} performs ascii dammit using the following expression \emph{bad_chars = str("").join([chr(i) for i in range(128, 256)])}. Applies to any kind of R data type.

the \emph{Asciionly} method returns the same result as the \emph{Asciidammit} method but for character strings using the python \emph{.translate()} function.

the \emph{Validate_string} method checks that the input has length and that length is greater than 0

Some of the utils functions are used as secondary methods in the \emph{FuzzExtract} class. See the examples of the \emph{FuzzExtract} class for more details.
}
\section{Methods}{


\describe{
 \item{\code{FuzzUtils$new()}}{}

 \item{\code{--------------}}{}

 \item{\code{Full_process(string = NULL, force_ascii = TRUE, decoding = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{INTR(n = 2.0)}}{}

 \item{\code{--------------}}{}

 \item{\code{Make_type_consistent(string1 = NULL, string2 = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Asciidammit(input = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Asciionly(string = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Validate_string(string = NULL)}}{}
 }
}

\examples{

try({
  if (reticulate::py_available(initialize = FALSE)) {

    if (check_availability()) {

      library(fuzzywuzzyR)

      s1 = 'Frodo Baggins'

      s2 = 'Bilbo Baggin'

      init = FuzzUtils$new()

      init$Full_process(string = s1, force_ascii = TRUE)

      init$INTR(n = 2.0)

      init$Make_type_consistent(string1 = s1, string2 = s2)

      #------------------------------------
      # 'Asciidammit' with character string
      #------------------------------------

      init$Asciidammit(input = s1)

      #----------------------------------------------------------------
      # 'Asciidammit' with data.frame(123) [ or any kind of data type ]
      #----------------------------------------------------------------

      init$Asciidammit(input = data.frame(123))

      init$Asciionly(string = s1)

      init$Validate_string(string = s2)
    }
  }
}, silent=TRUE)
}
\references{
https://github.com/seatgeek/fuzzywuzzy/blob/master/fuzzywuzzy/utils.py, https://docs.python.org/3/library/codecs.html#standard-encodings
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FuzzUtils-new}{\code{FuzzUtils$new()}}
\item \href{#method-FuzzUtils-Full_process}{\code{FuzzUtils$Full_process()}}
\item \href{#method-FuzzUtils-INTR}{\code{FuzzUtils$INTR()}}
\item \href{#method-FuzzUtils-Make_type_consistent}{\code{FuzzUtils$Make_type_consistent()}}
\item \href{#method-FuzzUtils-Asciidammit}{\code{FuzzUtils$Asciidammit()}}
\item \href{#method-FuzzUtils-Asciionly}{\code{FuzzUtils$Asciionly()}}
\item \href{#method-FuzzUtils-Validate_string}{\code{FuzzUtils$Validate_string()}}
\item \href{#method-FuzzUtils-clone}{\code{FuzzUtils$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzUtils-new"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzUtils-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzUtils$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzUtils-Full_process"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzUtils-Full_process}{}}}
\subsection{Method \code{Full_process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzUtils$Full_process(string = NULL, force_ascii = TRUE, decoding = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{string}}{a character string.}

\item{\code{force_ascii}}{allow only ASCII characters (force convert to ascii)}

\item{\code{decoding}}{either NULL or a character string. If not NULL then the \emph{decoding} parameter takes one of the standard python encodings (such as 'utf-8'). See the \emph{details} and \emph{references} link for more information (in this class it applies only to the \emph{Full_process} function)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzUtils-INTR"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzUtils-INTR}{}}}
\subsection{Method \code{INTR()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzUtils$INTR(n = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{a float number}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzUtils-Make_type_consistent"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzUtils-Make_type_consistent}{}}}
\subsection{Method \code{Make_type_consistent()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzUtils$Make_type_consistent(string1 = NULL, string2 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{string1}}{a character string.}

\item{\code{string2}}{a character string.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzUtils-Asciidammit"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzUtils-Asciidammit}{}}}
\subsection{Method \code{Asciidammit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzUtils$Asciidammit(input = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{any kind of data type (applies to the \emph{Asciidammit} method)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzUtils-Asciionly"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzUtils-Asciionly}{}}}
\subsection{Method \code{Asciionly()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzUtils$Asciionly(string = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{string}}{a character string.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzUtils-Validate_string"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzUtils-Validate_string}{}}}
\subsection{Method \code{Validate_string()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzUtils$Validate_string(string = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{string}}{a character string.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzUtils-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzUtils-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzUtils$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
