% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{future.mirai}
\alias{future.mirai}
\alias{future.mirai-package}
\title{future.mirai: A Future API for Parallel Processing using 'mirai'}
\description{
The \pkg{future.mirai} package implements the Future API
using the \pkg{mirai} package.
}
\examples{
plan(mirai_multisession)

# A function that returns a future
# (note that N is a global variable)
f <- function() future({
  4 * sum((runif(N) ^ 2 + runif(N) ^ 2) < 1) / N
}, seed = TRUE)

# Run a simple sampling approximation of pi in parallel using  M * N points:
N <- 1e6  # samples per worker
M <- 10   # iterations
pi_est <- Reduce(sum, Map(value, replicate(M, f()))) / M
print(pi_est)

## Switch back to sequential processing, which also
## shuts down the automatically launched mirai workers 
plan(sequential)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://future.mirai.futureverse.org}
  \item \url{https://github.com/futureverse/future.mirai}
  \item Report bugs at \url{https://github.com/futureverse/future.mirai/issues}
}

}
\author{
\strong{Maintainer}: Henrik Bengtsson \email{henrikb@braju.com} (\href{https://orcid.org/0000-0002-7579-5165}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Charlie Gao \email{charlie.gao@shikokuchuo.net} (\href{https://orcid.org/0000-0002-0750-061X}{ORCID}) (For 'mirai'-related patches and implementing feature requests in 'mirai') [contributor]
}

}
