# WARNING - Generated by {fusen} from dev/flat_sepuku.Rmd: do not edit by hand # nolint: line_length_linter.

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))

test_that("sepuku is a function", {
  expect_true(inherits(sepuku, "function"))
})

usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  test_that("sepuku checks that a dev/ folder exists", {
    #  Check for a dev folder
    expect_error(
      sepuku(force = TRUE),
      "No dev/ folder have been found. Are you sure that your package has been initiated with fusen ?"
    )
  })


  test_that("sepuku checks whether a fusen config file exists or not", {
    dir.create(file.path(dummypackage, "dev"))
    expect_message(
      sepuku(force = TRUE),
      "No fusen configuration file found. The flat files to be deleted will be identified as Rmd or qmd files starting with 'flat' in the dev/ and dev/flat_history folders."
    )
  })

  dev_file1 <- add_minimal_flat(
    pkg = dummypackage,
    flat_name = "flat1.Rmd",
    open = FALSE
  )

  # To add the config file a first inflate is needed
  suppressMessages(
    inflate(
      pkg = dummypackage,
      flat_file = dev_file1,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )
  )

  expect_message(
    sepuku(force = TRUE),
    "A fusen configuration file was found. The flat files to be deleted will be identified as files listed in this configuration file as well as Rmd or qmd files starting with 'flat' in the dev/ and dev/flat_history folders. The configuration file will also be deleted."
  )
})


unlink(dummypackage, recursive = TRUE)

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))

usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  dir.create(file.path(dummypackage, "dev"))


  test_that("sepuku warns the user if no flat files were detected", {
    expect_message(
      sepuku(force = TRUE),
      "No flat files were detected."
    )
  })



  test_that("sepuku informs the user about the flat files that were detected", {
    dir.create(file.path(dummypackage, "dev", "flat_history"))
    file.create(file.path(dummypackage, "dev", "flat_history", "flat_old.Rmd"))
    file.create(file.path(dummypackage, "dev", "flat_history", "flat_old.qmd"))
    file.create(file.path(dummypackage, "dev", "flat_qmd.qmd"))
    dev_file1 <- add_minimal_flat(
      pkg = dummypackage,
      flat_name = "flat1.Rmd",
      open = FALSE
    )
    inflate(
      pkg = dummypackage,
      flat_file = dev_file1,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )

    expect_message(
      sepuku(force = TRUE, verbose = TRUE),
      "The following flat files were detected and will therefore be deleted from your package:\ndev/flat_flat1.Rmd\ndev/flat_qmd.qmd\ndev/flat_history/flat_old.Rmd\ndev/flat_history/flat_old.qmd"
    )
  })
})
unlink(dummypackage, recursive = TRUE)


dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))

usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  dir.create(file.path(dummypackage, "dev"))
  usethis::use_r("some_R_file.R", open = FALSE)
  usethis::use_test("some_test.R", open = FALSE)
  dir.create(file.path(dummypackage, "vignettes"))
  file.create(file.path(dummypackage, "vignettes", "somevignette.Rmd"))


  test_that("sepuku warns the user if no files in R, tests or vignettes have to be modified", {
    expect_message(
      sepuku(force = FALSE),
      "No fusen-related tags have been found in any files located in R/, tests/ and vignettes/ folders."
    )
  })



  test_that("sepuku informs the user about the files with fusen tags that were detected", {
    dev_file1 <- add_minimal_flat(
      pkg = dummypackage,
      flat_name = "flat1.Rmd",
      open = FALSE
    )
    inflate(
      pkg = dummypackage,
      flat_file = dev_file1,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )
    dev_file2 <- add_minimal_flat(
      pkg = dummypackage,
      flat_name = "flat2.Rmd",
      open = FALSE
    )
    inflate(
      pkg = dummypackage,
      flat_file = dev_file2,
      vignette_name = "Get started 2",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )

    expect_message(
      sepuku(force = TRUE, verbose = TRUE),
      "The following files have been identified as containing fusen-related tags and will therefore be modified:\nR/flat1_rmd.R\nR/flat2_rmd.R\ntests/testthat/test-flat1_rmd.R\ntests/testthat/test-flat2_rmd.R\nvignettes/get-started-2.Rmd\nvignettes/get-started.Rmd"
    )
  })
})
unlink(dummypackage, recursive = TRUE)

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))

usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  dev_file1 <- add_minimal_flat(
    pkg = dummypackage,
    flat_name = "flat1.Rmd",
    open = FALSE
  )
  inflate(
    pkg = dummypackage,
    flat_file = dev_file1,
    vignette_name = "Get started",
    check = FALSE,
    open_vignette = FALSE,
    document = TRUE,
    overwrite = "yes"
  )


  if (interactive()) {
    cli::cat_rule(
      "Test: You should be asked a question: please answer 'y' during tests"
    )
    test_that("sepuku tells the users that files will be modified or deleted and that it is irreversible", {
      expect_message(
        sepuku(force = FALSE),
        "Some files are about to be deleted or modified. This operation is irreversible."
      )

      do_it <- readline("Test: Were you just asked you were sure what you were doing? (y/n)") == "y"
      expect_true(do_it)
    })
  }
})
unlink(dummypackage, recursive = TRUE)

dummypackage <- tempfile(paste0(sample(letters, 10), collapse = ""))
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))

usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  dir.create(file.path(dummypackage, "dev"))
  dir.create(file.path(dummypackage, "dev", "flat_history"))

  dev_file1 <- add_minimal_flat(
    pkg = dummypackage,
    flat_name = "flat1.Rmd",
    open = FALSE
  )

  dev_file2 <- add_minimal_flat(
    pkg = dummypackage,
    flat_name = "flat2.Rmd",
    open = FALSE
  )

  inflate(
    pkg = dummypackage,
    flat_file = dev_file1,
    vignette_name = "Get started",
    check = FALSE,
    open_vignette = FALSE,
    document = TRUE,
    overwrite = "yes"
  )

  inflate(
    pkg = dummypackage,
    flat_file = dev_file2,
    vignette_name = "Get started 2",
    check = FALSE,
    open_vignette = FALSE,
    document = TRUE,
    overwrite = "yes"
  )

  deprecate_flat_file(
    file.path(dummypackage, "dev", "flat_flat1.Rmd")
  )

  file.create(file.path(dummypackage, "dev", "flat_history", "flat_old.qmd"))
  file.create(file.path(dummypackage, "dev", "flat_qmd.qmd"))

  sepuku(force = TRUE)

  expect_false(
    file.exists(
      file.path(dummypackage, "dev", "config_fusen.yaml")
    )
  )
  expect_equal(
    length(
      list.files(
        file.path(dummypackage, "dev"),
        pattern = "flat.*\\.Rmd"
      )
    ),
    0
  )

  expect_equal(
    length(
      list.files(
        file.path(dummypackage, "dev"),
        pattern = "^flat.*\\.qmd"
      )
    ),
    0
  )

  expect_equal(
    length(
      list.files(
        file.path(dummypackage, "dev", "flat_history"),
        pattern = "flat.*\\.Rmd"
      )
    ),
    0
  )

  expect_equal(
    length(
      list.files(
        file.path(dummypackage, "dev", "flat_history"),
        pattern = "^flat.*\\.qmd"
      )
    ),
    0
  )

  expect_equal(
    length(find_files_with_fusen_tags(pkg = dummypackage)),
    0
  )
})
