% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fapply.R
\name{fapply}
\alias{fapply}
\title{Apply a function over a list or vector with optional parallelism and progress}
\usage{
fapply(.x, .f, ncores = 1, pb = FALSE, cl = NULL, load_balancing = TRUE, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{Function to apply.}

\item{ncores}{Number of cores to use (default: 1 = sequential).}

\item{pb}{Show progress bar? (default: FALSE).}

\item{cl}{A cluster object (from parallel::makeCluster), or integer for core count.}

\item{load_balancing}{Logical. Use `parLapplyLB` if `TRUE` (default: `FALSE`).}

\item{...}{Additional arguments passed to `.f`.}
}
\value{
A list of results.
}
\description{
A lightweight and fast version of `lapply()` with support for multicore (Unix) and snow-style
clusters via `parallel`, with internal progress bar tracking and message suppression.
}
\examples{
# Basic usage (sequential)
fapply(1:5, sqrt)

# With progress bar (sequential)
fapply(1:5, function(x) { Sys.sleep(0.1); x^2 }, pb = TRUE)

# Multicore on Unix (if available)
\donttest{
if (.Platform$OS.type != "windows") {
  fapply(1:10, sqrt, ncores = 2)
}
}

# With user-created cluster (portable across platforms)
\donttest{
cl <- parallel::makeCluster(2)
fapply(1:10, sqrt, cl = cl)
parallel::stopCluster(cl)
}

# Heavy computation example with chunked parallelism
\donttest{
heavy_fn <- function(x) { Sys.sleep(0.05); x^2 }
fapply(1:20, heavy_fn, ncores = 2, pb = TRUE)
}

}
