% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrackx.R
\name{probtrackx}
\alias{probtrackx}
\title{Probabilistic diffusion tractography with multiple fibre orientations}
\usage{
probtrackx(
  samples = "merged",
  mask,
  seed,
  outdir = "fdt_paths",
  verbose = TRUE,
  mode = NULL,
  targetmasks = NULL,
  mask2 = NULL,
  waypoints = NULL,
  network = FALSE,
  mesh = NULL,
  seedref = NULL,
  dir = FALSE,
  forcedir = FALSE,
  opd = FALSE,
  pd = FALSE,
  os2t = FALSE,
  avoid = NULL,
  stop = NULL,
  xfm = NULL,
  invxfm = NULL,
  nsamples = 5000,
  nsteps = 2000,
  distthresh = 0,
  cthr = 0.2,
  fibthresh = 0.01,
  sampvox = FALSE,
  steplength = 0.5,
  loopcheck = FALSE,
  usef = FALSE,
  randfib = c(0, 1, 2, 3),
  fibst = 1,
  modeuler = FALSE,
  rseed = NULL,
  s2tastext = FALSE,
  opts = ""
)
}
\arguments{
\item{samples}{(nifti/character) Basename for samples files}

\item{mask}{(nifti/character) Bet binary mask file in diffusion space}

\item{seed}{(nifti/character) Seed volume, or voxel, or ascii file with multiple volumes, or freesurfer label file}

\item{outdir}{(character) Output file (default='fdt_paths')}

\item{verbose}{(logical/numeric) Verbose level, [0-2]}

\item{mode}{(character) Use --mode=simple for single seed voxel}

\item{targetmasks}{(character) File containing a list of target masks - required for seeds_to_targets classification}

\item{mask2}{(nifti/character) Second mask in twomask_symm mode.}

\item{waypoints}{(nifti/character) Waypoint mask or ascii list of waypoint masks - only keep paths going through ALL the masks}

\item{network}{(logical) Activate network mode - only keep paths going through at least one seed mask (required if multiple seed masks)}

\item{mesh}{(character) Freesurfer-type surface descriptor (in ascii format)}

\item{seedref}{(nifti/character) Reference vol to define seed space in simple mode - diffusion space assumed if absent}

\item{dir}{(logical) Directory to put the final volumes in - code makes this directory - default='logdir'}

\item{forcedir}{(logical) Use the actual directory name given - i.e. don't add + to make a new directory}

\item{opd}{(logical) Output path distribution}

\item{pd}{(logical) Correct path distribution for the length of the pathways}

\item{os2t}{(logical) Output seeds to targets}

\item{avoid}{(nifti/character) Reject pathways passing through locations given by this mask}

\item{stop}{(nifti/character) Stop tracking at locations given by this mask file}

\item{xfm}{(character) Transform taking seed space to DTI space (either FLIRT matrix or FNIRT warpfield) - default is identity}

\item{invxfm}{(character) Transform taking DTI space to seed space (compulsory when using a warpfield for seeds_to_dti)}

\item{nsamples}{(numeric) Number of samples - default=5000}

\item{nsteps}{(numeric) Number of steps per sample - default=2000}

\item{distthresh}{(numeric) Discards samples shorter than this threshold (in mm - default=0)}

\item{cthr}{(numeric) Curvature threshold - default=0.2}

\item{fibthresh}{(numeric) Volume fraction before subsidiary fibre orientations are considered - default=0.01}

\item{sampvox}{(logical) Sample random points within seed voxels}

\item{steplength}{(numeric) Steplength in mm - default=0.5}

\item{loopcheck}{(logical) Perform loopchecks on paths - slower, but allows lower curvature threshold}

\item{usef}{(logical) Use anisotropy to constrain tracking}

\item{randfib}{(numeric) Default 0. Set to 1 to randomly sample initial fibres (with f > fibthresh). Set to 2 to sample in proportion fibres (with f>fibthresh) to f. Set to 3 to sample ALL populations at random (even if f<fibthresh)}

\item{fibst}{(numeric) Force a starting fibre for tracking - default=1, i.e. first fibre orientation. Only works if randfib==0}

\item{modeuler}{(logical) Use modified euler streamlining}

\item{rseed}{(numeric) Random seed}

\item{s2tastext}{(logical) Output seed-to-target counts as a text file (useful when seeding from a mesh)}

\item{opts}{Additional options or way to specify things instead of command
line arguments}
}
\value{
A filename of the output file
}
\description{
This function wraps \code{probtrackx} from FSL
}
