% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.R
\name{fast}
\alias{fast}
\alias{fast_all}
\alias{fast_nobias_all}
\alias{fsl_fast}
\alias{fslfast}
\alias{fsl_fast_nobias}
\alias{fast_nobias}
\alias{fslfast_nobias}
\title{FSL FAST}
\usage{
fast(
  file,
  outfile = NULL,
  bias_correct = TRUE,
  retimg = TRUE,
  reorient = FALSE,
  intern = FALSE,
  opts = "",
  type = c("T1", "T2", "PD"),
  out_type = c("seg", "mixeltype", "pve_0", "pve_1", "pve_2", "pveseg"),
  verbose = TRUE,
  all_images = FALSE,
  ...
)

fast_all(..., all_images = TRUE)

fast_nobias_all(..., bias_correct = FALSE, all_images = FALSE)

fsl_fast(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)

fslfast(...)

fsl_fast_nobias(
  ...,
  bias_correct = FALSE,
  outfile = tempfile(fileext = ".nii.gz"),
  retimg = FALSE
)

fast_nobias(..., bias_correct = FALSE)

fslfast_nobias(..., bias_correct = FALSE)
}
\arguments{
\item{file}{(character) image to be manipulated}

\item{outfile}{(character) resultant image name (optional)}

\item{bias_correct}{(logical) if \code{FALSE}, then 
\code{"--nobias"} is passed to FAST.  Additional options can be 
sent using \code{opts}, but this is the most commonly one changed.}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link[neurobase]{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{opts}{(character) operations to be passed to \code{fast}}

\item{type}{type of image T1, T2, or PD.}

\item{out_type}{(character) Suffix to grab from outfile.  For 
example, output filename is \code{paste0(outfile, "_", out_type)}}

\item{verbose}{(logical) print out command before running}

\item{all_images}{If \code{retimg}}

\item{...}{additional arguments passed to \code{\link[neurobase]{readnii}}.}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{fast} from FSL
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
