% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume.R
\name{vox2ras_tkr}
\alias{vox2ras_tkr}
\title{The FreeSurfer default vox2ras_tkr matrix.}
\usage{
vox2ras_tkr()
}
\value{
numeric 4x4 matrix, the FreeSurfer vox2ras_tkr matrix.
}
\description{
Applying this matrix to a FreeSurfer CRS index of a conformed volume will give you the RAS coordinates of the voxel in surface coordinates, i.e., in the coordinates used in surface file like `lh.white`. The central voxel is 127,127,127 when using zero-based indices (or 128,128,128 when using one-based indices), meaning its surface RAS coordinates are 0.0, 0.0, 0.0. The returned matrix is the inverse of the `ras2vox_tkr` matrix.
}
\examples{
   # Compute surface RAS coordinate of voxel with CRS (0L, 0L, 0L):
   vox2ras_tkr() \%*\% c(0, 0, 0, 1);
   # Show that voxel with CRS (128,128,128) is at the
   #  origin (0.0, 0.0, 0.0) of the surface RAS coordinate system:
   (vox2ras_tkr() \%*\% c(128, 128, 128, 1))[1:3];

}
\seealso{
Other surface and volume coordinates: 
\code{\link{ras2vox_tkr}()}
}
\concept{surface and volume coordinates}
