% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume_3d.R
\name{vol.hull}
\alias{vol.hull}
\title{Retain only the outer hull voxels of the foreground.}
\usage{
vol.hull(volume, thickness = 1L, axes = c(2L))
}
\arguments{
\item{volume}{numeric 3d array, must contain foreground voxel and background voxels. The latter must have value `NA`. This function assumes that a solid foreground object surrounded by background exists in the volume.}

\item{thickness}{integer, the width of the border in voxels, i.e., how many of the voxels in each upright column to keep at the top and at the bottom.}

\item{axes}{integer vector, the axes to use. Valid values in the vector are 1L, 2L and 3L. You will have to use all 3 axes if you do not want any holes in the object. (Obvisouly, having noise around the object can still lead to holes.)}
}
\value{
numeric 3d array, a filtered version of the input. It contains at least as many `NA` voxels as the input. If the function had any effect, it contains a lot more `NA` values. The other values and the volume dimensions are left unchanged.
}
\description{
Filters the *foreground* voxel in the volume by keeping only an outer border of voxels, and setting the inner core voxels to `NA`. This is a utility function for voxel-based visualization. The goal is to remove the inner voxels, which will not be visible anyways, and thus to dramatically reduce the number of triangles that will need to be computed for the mesh.
}
