% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{pervertexdata.smoothnn}
\alias{pervertexdata.smoothnn}
\title{Perform iterative nearest-neighbor smoothing of per-vertex data.}
\usage{
pervertexdata.smoothnn(surface, data, num_iter, k = 1L)
}
\arguments{
\item{surface}{an \code{fs.surface} instance}

\item{data}{numerical vector, the per-vertex data for the surface. Values set to \code{NA} will be ignore, so you can apply a mask before this operation (e.g., by setting the values for all vertices of the medial mask to \code{NA}).}

\item{num_iter}{positive scalar integer, the number of times to perform the averaging. Depends on the mesh resolution and desired smoothing, higher resolution meshes will need more passes. Typical values are in range 20 to 150, but also depend on the setting of parameter 'k', of course.}

\item{k}{positive scalar integer, the neighborhood size in hops along the mesh edges (the k for the k-ring neighborhood). For higher resolution meshes it makes sense to increase this, typical values are roughly in range 1 to 10.}
}
\description{
Smoothing of surface data by iterative mesh neighborhood averaging. Assigns to each vertex the average of the values in its 1-ring neighborhood (based on the mesh edges).
}
\note{
The iteration is currently done in R, which means the performance is not great.

This does NOT smooth the mesh, it smoothes per-vertex values assigned to mesh vertices.

To see relevant smoothing for full-resolution FreeSurfer meshes, try setting \code{num_iter=50, k=8} for a start.
}
\examples{
\dontrun{
sjd = fsaverage.path(T);
sj = "fsaverage3";
surface = subject.surface(sjd, sj, hemi = "lh");
th = subject.morph.native(sjd, sj, "thickness", hemi="lh", cortex_only=T);
th_smooth = pervertexdata.smoothnn(surface, th, num_iter=15L);
vis.data.on.subject(sjd, sj, morph_data_lh = th);
vis.data.on.subject(sjd, sj, morph_data_lh = th_smooth);
}

}
\keyword{internal}
