% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas.R
\name{label.to.annot}
\alias{label.to.annot}
\title{Merge several labels into an annotation}
\usage{
label.to.annot(
  label_vertices_by_region,
  num_vertices_in_surface,
  colortable_df = NULL,
  index_of_unknown_region = 1L
)
}
\arguments{
\item{label_vertices_by_region}{named list of integer vectors, the keys are strings which define region names, and the values are integer vectors: the vertex indices of the region.}

\item{num_vertices_in_surface}{integer, total number of vertices in the surface mesh}

\item{colortable_df}{NULL or dataframe, a colortable. It must contain the columns 'struct_name', 'r', 'g', 'b', and 'a'. All other columns will be derived if missing. The entries in 'struct_name' must match keys from the 'label_vertices_by_region' parameter. There must be one more row in here than there are labels. This row identifies the 'unknown' region (see also parameter 'index_of_unknown_region'). If NULL, a colortable will be auto-generated.}

\item{index_of_unknown_region}{positive integer, the index of the row in 'colortable_df' that defines the 'unknown' or 'background' region to which all vertices will be assigned which are *not* part of any of the given labels.}
}
\value{
an annotation, see \code{\link[freesurferformats]{read.fs.annot}} for details.
}
\description{
Merge several labels and a colortable into an annotation.
}
\examples{
  # Create two labels. Real-word labels would have more vertices, of course.
  label1 = c(46666, 467777);
  label2 = c(99888, 99889);
  label_vertices = list("region1"=label1, "region2"=label2);
  colortable_df = data.frame("struct_index"=seq(0, 2),
   "struct_name"=c("unknown", "region1", "region2"),
   "r"=c(255L, 255L, 0L), "g"=c(255L, 0L, 255L), "b"=c(255L, 0L, 0L), "a"=c(0L, 0L, 0L));
  annot = label.to.annot(label_vertices, 100000, colortable_df);

}
\seealso{
Other atlas functions: 
\code{\link{get.atlas.region.names}()},
\code{\link{group.agg.atlas.native}()},
\code{\link{group.agg.atlas.standard}()},
\code{\link{group.annot}()},
\code{\link{group.label.from.annot}()},
\code{\link{label.from.annotdata}()},
\code{\link{regions.to.ignore}()},
\code{\link{spread.values.over.annot}()},
\code{\link{spread.values.over.hemi}()},
\code{\link{spread.values.over.subject}()},
\code{\link{subject.annot}()},
\code{\link{subject.atlas.agg}()},
\code{\link{subject.label.from.annot}()},
\code{\link{subject.lobes}()}
}
\concept{atlas functions}
