% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{hemi.lobe.labels}
\alias{hemi.lobe.labels}
\title{Compute lobe labels for a single hemi from aparc atlas.}
\usage{
hemi.lobe.labels(
  subjects_dir,
  subject_id,
  hemi,
  include_cingulate = TRUE,
  as_annot = FALSE
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name.}

\item{include_cingulate}{logical, whether to include the vertices of the cingulate in the lobes}

\item{as_annot}{return a hemilist of annotations instead of the return value described in the *value* section}
}
\description{
Compute lobe labels for a single hemi from aparc atlas.
}
\note{
See \code{\link[fsbrain]{subject.lobes}} for details.
}
\keyword{internal}
