% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{run_cv}
\alias{run_cv}
\title{Run the bayesian model with spatial cross validation}
\usage{
run_cv(
  focal_vs_comp,
  comp_dist,
  blocks,
  prior_param = NULL,
  run_shuffle = FALSE
)
}
\arguments{
\item{focal_vs_comp}{data frame from \code{\link[=create_focal_vs_comp]{create_focal_vs_comp()}}}

\item{comp_dist}{Distance to determine which neighboring trees to a focal tree are competitors.}

\item{blocks}{An sf object of a \code{blockCV} block output}

\item{prior_param}{A list of \verb{\{a_0, b_0, mu_0, V_0\}} prior hyperparameters.
Defaults to \code{a_0 = 250}, \code{b_0 = 250}, \code{mu_0} a vector of zeros of
length \eqn{p + 1}, \code{V_0} an identity matrix of dimension \eqn{(p + 1) x (p
  + 1)}}

\item{run_shuffle}{boolean as to whether to run permutation test shuffle of
competitor tree species within a particular focal_ID}
}
\value{
\code{focal_vs_comp} with new column of predicted \code{growth_hat}
}
\description{
This function carries out the bayesian modeling process with spatial
cross-validation as described in Allen and Kim (2020). Given a
focal-competitor data frame, it appends a column with predicted growth values.
}
\examples{

run_cv(
  focal_vs_comp_ex,
  comp_dist = 1,
  blocks = blocks_ex
)
}
\seealso{
Other modeling functions: 
\code{\link{comp_bayes_lm}()},
\code{\link{create_bayes_lm_data}()},
\code{\link{predict.comp_bayes_lm}()}
}
\concept{modeling functions}
