% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/reg-methods.R
\name{onsets}
\alias{onsets}
\alias{onsets.Reg}
\title{Get event onsets from an object}
\usage{
onsets(x, ...)

\method{onsets}{Reg}(x, ...)
}
\arguments{
\item{x}{Object containing onset information}

\item{...}{Additional arguments passed to methods}
}
\value{
Numeric vector of onsets
}
\description{
Generic accessor returning event onset times in seconds.
}
\examples{
# Create a regressor with event onsets
reg <- regressor(onsets = c(1, 5, 10, 15), hrf = HRF_SPMG1, span = 20)
onsets(reg)
}
