% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{getHRF}
\alias{getHRF}
\title{Get HRF by Name}
\usage{
getHRF(
  name = "spmg1",
  nbasis = 5,
  span = 24,
  lag = 0,
  width = 0,
  summate = TRUE,
  normalize = FALSE,
  ...
)
}
\arguments{
\item{name}{Character string specifying the HRF type. Options include:
\itemize{
  \item \code{"spmg1"}, \code{"spmg2"}, \code{"spmg3"} - SPM canonical HRFs
  \item \code{"gamma"}, \code{"gaussian"} - Simple parametric HRFs
  \item \code{"fir"} - Finite Impulse Response basis
  \item \code{"bspline"} or \code{"bs"} - B-spline basis
  \item \code{"fourier"} - Fourier basis
  \item \code{"daguerre"} - Daguerre spherical basis
  \item \code{"tent"} - Tent (linear spline) basis
}}

\item{nbasis}{Number of basis functions (for basis set types)}

\item{span}{Temporal window in seconds (default: 24)}

\item{lag}{Time lag in seconds to apply (default: 0)}

\item{width}{Block width for block designs (default: 0)}

\item{summate}{Whether to sum responses in block designs (default: TRUE)}

\item{normalize}{Whether to normalize the HRF (default: FALSE)}

\item{...}{Additional arguments passed to generator functions (e.g., \code{scale} for daguerre)}
}
\value{
An HRF object
}
\description{
Retrieves an HRF by name from the registry and optionally applies decorators.
This provides a unified interface for creating both pre-defined HRF objects
and custom basis sets with specified parameters.
}
\details{
For single HRF types (spmg1, gamma, gaussian), the function returns
pre-defined objects. For basis set types (fir, bspline, fourier, daguerre),
it calls the appropriate generator function with the specified parameters.
}
\examples{
# Get pre-defined canonical HRF
canonical <- getHRF("spmg1")

# Create custom FIR basis with 20 bins
fir20 <- getHRF("fir", nbasis = 20, span = 30)

# Create B-spline basis with lag
bs_lag <- getHRF("bspline", nbasis = 8, lag = 2)

# Create blocked Gaussian HRF
block_gauss <- getHRF("gaussian", width = 5)
}
