% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{gen_hrf_blocked}
\alias{gen_hrf_blocked}
\alias{hrf_blocked}
\title{Generate a Blocked HRF Function}
\usage{
gen_hrf_blocked(
  hrf = hrf_gaussian,
  width = 5,
  precision = 0.1,
  half_life = Inf,
  summate = TRUE,
  normalize = FALSE,
  ...
)

hrf_blocked(
  hrf = hrf_gaussian,
  width = 5,
  precision = 0.1,
  half_life = Inf,
  summate = TRUE,
  normalize = FALSE,
  ...
)
}
\arguments{
\item{hrf}{A function representing the hemodynamic response function. Default is `hrf_gaussian`.}

\item{width}{A numeric value specifying the width of the block in seconds. Default is 5.}

\item{precision}{A numeric value specifying the sampling resolution in seconds. Default is 0.1.}

\item{half_life}{A numeric value specifying the half-life of the exponential decay function, used to model response attenuation. Default is `Inf`, which means no decay.}

\item{summate}{A logical value indicating whether to allow each impulse response function to "add" up. Default is `TRUE`.}

\item{normalize}{A logical value indicating whether to rescale the output so that the peak of the output is 1. Default is `FALSE`.}

\item{...}{Extra arguments passed to the HRF function.}
}
\value{
A \code{function} representing the blocked HRF.

A \code{function} representing the blocked HRF.
}
\description{
The `gen_hrf_blocked` function creates a blocked HRF by convolving the input HRF with a boxcar function. This can be used to model block designs in fMRI analysis.
}
\section{Functions}{
\itemize{
\item \code{hrf_blocked()}: alias for gen_hrf_blocked

}}
\examples{
# Deprecated: use gen_hrf(..., width = 10) or block_hrf(HRF, width = 10)
}
\seealso{
Other gen_hrf: 
\code{\link{gen_hrf_lagged}()}
}
\concept{gen_hrf}
