% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{stability.value}
\alias{stability.value}
\title{Estimates network stability}
\usage{
stability.value(
  val.mat,
  biomasses,
  efficiencies,
  metabolic.types,
  ef.level = "prey",
  full.output = FALSE
)
}
\arguments{
\item{val.mat}{A matrix describing fluxes between species (usually a result of \code{\link[fluxweb]{fluxing}} function).}

\item{biomasses}{A vector of species biomasses.}

\item{efficiencies}{A vector or an array of conversion efficiencies of species in the adjacency matrix. These values describe the proportion of consumed energy that is converted to biomass of the consumer.}

\item{metabolic.types}{A vector containing information on species type (\code{"detritus"}, \code{"plant"} or \code{"animal"})}

\item{ef.level}{Set to \code{"prey"} if efficiencies are defined by prey, \code{"pred"} if they are a property of the predator.}

\item{full.output}{Logical, if \code{TRUE} function return supplementary informations.}
}
\value{
Maximum eigenvalue of the Jacobian matrix of a Lotka Voltera like system of equations. If full.output, Jacobian eigenvalues and eigenvectors are returned.
}
\description{
Computes resilience of the system through Jacobian matrix eigenvalues.
}
\details{
\itemize{


\item{\code{efficiencies}:} Determines how efficient species are to convert energy (see \code{ef.level} for more details).
Providing an array will assume values depending on both prey and predator identity.


\item{\code{ef.level}:} If \code{"prey"} (resp \code{"pred"}), the total amount of energy that can be metabolized from a trophic link
will be determined by prey (resp pred) identity. \code{"link.specific"} assumes that efficiencies are defined for each trophic interaction
and implies \code{efficiencies} parameter to be a matrix

\item{\code{full.output}:} If \code{TRUE}, function result is a list of eigenvalues and eigenvectors of the Jacobian matrix.
}
}
\examples{
losses = 0.15 * groups.level$bodymasses^(-0.25)
# define metbolic types:
met.types = rep('animal', length(losses))
met.types[groups.level$efficiencies == 0.545] = 'plant'

val.mat = fluxing(groups.level$mat, 
                  groups.level$biomasses, 
                  losses, 
                  groups.level$efficiencies, 
                  bioms.pref = TRUE, 
                  ef.level = "pred")
                  
stability.value(val.mat, 
                groups.level$biomasses, 
                groups.level$efficiencies,
                metabolic.types = met.types,
                ef.level = "pred")

}
\author{
Benoit Gauzens, \email{benoit.gauzens@gmail.com}
}
