% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prm.R
\name{apply_prm}
\alias{apply_prm}
\title{Apply Physical Range Module (PRM) bounds to AmeriFlux-style data}
\usage{
apply_prm(.data, include = NULL, skip_qc = TRUE, note = TRUE, summarize = TRUE)
}
\arguments{
\item{.data}{A data.frame or tibble.}

\item{include}{Optional character vector of base family names to apply (e.g., "SWC", "P").
If \code{NULL}, all families are applied.}

\item{skip_qc}{Logical; when TRUE, skip columns that look like flags:
names ending/containing \verb{_QC} or \verb{_SSITC_TEST} (case-insensitive).
Default: TRUE.}

\item{note}{Logical; print a per-column summary with expected units, PRM range, and counts.}

\item{summarize}{Logical; if \code{TRUE}, return a list with \code{data} and \code{summary}; otherwise return only the clamped data frame.}
}
\value{
If \code{summarize = TRUE}, a list with \code{data} and \code{summary}; else a data.frame.
}
\description{
Clamps values to PRM ranges by variable \emph{family} (e.g., \verb{^SWC($|_)}, \verb{^P($|_)}).
Columns with "QC" in their names are skipped by default. Out-of-range values
are set to \code{NA}. No columns are removed.
}
