% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_profile.R
\name{update_profile}
\alias{update_profile}
\title{Update user profile}
\usage{
update_profile(
  id_token,
  display_name = NULL,
  photo_url = NULL,
  delete_attribute = NULL
)
}
\arguments{
\item{id_token}{String.    A Firebase Auth ID token for the user.}

\item{display_name}{String.    User's new display name. Defaults to \code{NULL}.}

\item{photo_url}{String.    User's new photo url. Defaults to \code{NULL}.}

\item{delete_attribute}{Character vector of attributes to delete.
Either "DISPLAY_NAME" or "PHOTO_URL". This will nullify these values.
Defaults to \code{NULL}.}
}
\value{
A named list with the following items:
\itemize{
\item \code{localId}:	The uid of the current user.
\item \code{email}:	User's email address.
\item \code{displayName}: User's new display name.
\item \code{photoUrl}: User's new photo url.
\item \code{passwordHash}:	Hash version of password.
\item \code{providerUserInfo}:	A named list of of all linked provider objects which
contain "providerId" and "federatedId".
\item \code{idToken}:	New Firebase Auth ID token for user.
\item \code{refreshToken}:	A Firebase Auth refresh token.
\item \code{expiresIn}:	string	The number of seconds in which the ID token expires.
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Update a user's profile (display name / photo URL).
}
\details{
Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-update-profile}{Firebase Auth REST API docs}
for more details
}
\examples{
\dontrun{
  update_profile(
    id_token = "id-token-goes-here",
    display_name = "new-user-display-name",
    photo_url = "url-to-user-photo"
  )

  # to delete the display name attribute:
  update_profile(
    delete_attribute = "DISPLAY_NAME"
  )
}
}
