% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_info.R
\name{set_run_info}
\alias{set_run_info}
\title{Set up finnts submission}
\usage{
set_run_info(
  experiment_name = "finn_fcst",
  run_name = "finn_fcst",
  storage_object = NULL,
  path = NULL,
  data_output = "csv",
  object_output = "rds",
  add_unique_id = TRUE
)
}
\arguments{
\item{experiment_name}{Name used to group similar runs under a
single experiment name.}

\item{run_name}{Name to distinguish one run of Finn from another.
The current time in UTC is appended to the run name to ensure
a unique run name is created.}

\item{storage_object}{Used to store outputs during a run to other
storage services in Azure. Could be a storage container object from
the 'AzureStor' package to connect to ADLS blob storage or a
OneDrive/SharePoint object from the 'Microsoft365R' package to connect
to a OneDrive folder or SharePoint site. Default of NULL will save outputs
to the local file system.}

\item{path}{String showing what file path the outputs should be written to.
Default of NULL will write the outputs to a temporary directory within R,
which will delete itself after the R session closes.}

\item{data_output}{String value describing the file type for data outputs.
Default will write data frame outputs as csv files. The other option
of 'parquet' will instead write parquet files.}

\item{object_output}{String value describing the file type for object
outputs. Default will write object outputs like trained models as
rds files. The other option of 'qs' will instead serialize R objects
as qs files by using the 'qs' package.}

\item{add_unique_id}{Add a unique id to end of run_name based on submission time.
Set to FALSE to supply your own unique run name, which is helpful in
multistage ML pipelines.}
}
\value{
A list of run information
}
\description{
Creates list object of information helpful in logging information
about your run.
}
\examples{
\donttest{
run_info <- set_run_info(
  experiment_name = "test_exp",
  run_name = "test_run_1"
)
}
}
