% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_models.R
\name{ensemble_models}
\alias{ensemble_models}
\title{Ensemble Models}
\usage{
ensemble_models(
  run_info,
  parallel_processing = NULL,
  inner_parallel = FALSE,
  num_cores = NULL,
  seed = 123
)
}
\arguments{
\item{run_info}{run info using the \code{\link[=set_run_info]{set_run_info()}} function}

\item{parallel_processing}{Default of NULL runs no parallel processing and
forecasts each individual time series one after another. 'local_machine'
leverages all cores on current machine Finn is running on. 'spark'
runs time series in parallel on a spark cluster in Azure Databricks or
Azure Synapse.}

\item{inner_parallel}{Run components of forecast process inside a specific
time series in parallel. Can only be used if parallel_processing is
set to NULL or 'spark'.}

\item{num_cores}{Number of cores to run when parallel processing is set up.
Used when running parallel computations on local machine or within Azure.
Default of NULL uses total amount of cores on machine minus one. Can't
be greater than number of cores on machine minus 1.}

\item{seed}{Set seed for random number generator. Numeric value.}
}
\value{
Ensemble model outputs are written to disk
}
\description{
Create ensemble model forecasts
}
\examples{
\donttest{
data_tbl <- timetk::m4_monthly \%>\%
  dplyr::rename(Date = date) \%>\%
  dplyr::mutate(id = as.character(id)) \%>\%
  dplyr::filter(
    Date >= "2013-01-01",
    Date <= "2015-06-01",
    id == "M750"
  )

run_info <- set_run_info()

prep_data(run_info,
  input_data = data_tbl,
  combo_variables = c("id"),
  target_variable = "value",
  date_type = "month",
  forecast_horizon = 3
)

prep_models(run_info,
  models_to_run = c("arima", "glmnet"),
  num_hyperparameters = 2
)

train_models(run_info,
  run_global_models = FALSE
)

ensemble_models(run_info)
}
}
