% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{raw_dataset}
\alias{raw_dataset}
\title{Build a raw dataset from averaged data}
\usage{
raw_dataset(data)
}
\arguments{
\item{data}{A data frame containing averaged source and mixture data. It is expected
to have columns for tracer means (prefixed with "mean_"), standard deviations
(prefixed with "sd_"), and a column "n" indicating the number of observations
for each source.}
}
\value{
A data frame representing the raw, non-averaged dataset, with each row
corresponding to an individual observation.
}
\description{
Generates a raw (non-averaged) dataset by sampling individual observations
from the mean and standard deviation values provided in an averaged input data frame.
For each source, it generates 'n' observations for each tracer by sampling from a
normal distribution using the provided mean and standard deviation. Mixture data
is appended directly without sampling.
}
