% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{plot_results}
\alias{plot_results}
\title{Displays the results of an unmixing analysis}
\usage{
plot_results(
  data,
  violin = T,
  bounds = c(0, 1),
  scaled = T,
  y_high = 1,
  colors = NULL,
  ncol = 1
)
}
\arguments{
\item{data}{A data frame, typically the output from the \code{unmix} function, containing the relative contributions of sediment sources.}

\item{violin}{A logical value. If \code{TRUE}, violin charts are used instead of density plots.}

\item{bounds}{A numeric vector of length 2 specifying the lower and upper bounds for the data.}

\item{scaled}{A logical value. If \code{TRUE}, the density plots are scaled.}

\item{y_high}{The maximum value for the y-axis.}

\item{colors}{A character vector of colors to use for the plots.}

\item{ncol}{The number of plots per row.}
}
\description{
This function generates a plot showing the relative contribution of sediment sources to each mixture. The output of the \code{unmix} function should be used as input for this function.
}
