% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loggers.R
\docType{data}
\name{loggers}
\alias{loggers}
\alias{logging}
\alias{logger_null}
\alias{logger_console}
\alias{logger_file}
\alias{logger_switch}
\alias{logger_logger}
\alias{common_log_format}
\alias{combined_log_format}
\title{App Logging}
\format{
An object of class \code{character} of length 1.

An object of class \code{character} of length 1.
}
\usage{
logger_null()

logger_console(format = "{time} - {event}: {message}")

logger_file(file, format = "{time} - {event}: {message}")

logger_switch(..., default = logger_null())

logger_logger(default_level = "INFO")

common_log_format

combined_log_format
}
\arguments{
\item{format}{A \link[glue:glue]{glue} string specifying the format of the log entry}

\item{file}{A file or connection to write to}

\item{...}{A named list of loggers to use for different events. The same
semantics as \link[base:switch]{switch} is used so it is possible to let events
\emph{fall through} e.g. \code{logger_switch(error =, warning = logger_file('errors.log'))}.}

\item{default}{A catch-all logger for use with events not defined in \code{...}}

\item{default_level}{The log level to use for events that are not \code{request},
\code{websocket}, \code{message}, \code{warning}, or \code{error}}
}
\description{
\code{fiery} has a build in logging mechanism that lets you capture event
information however you like. Every user-injested warnings and errors are
automatically captured by the logger along with most system errors as well.
\code{fiery} tries very hard not to break due to faulty app logic. This means that
any event handler error will be converted to an error log without \code{fiery}
stopping. In the case of request handlers a 500L response will be send back
if any error is encountered.
}
\section{Setting a logger}{

By default, \code{fiery} uses \code{logger_null()} which forwards warning and error
messages to \code{stderr()} and ignores any other logging events. To change this
behavior, set a different logger using the \code{set_logger()} method:

\if{html}{\out{<div class="sourceCode">}}\preformatted{app$set_logger(logger)
}\if{html}{\out{</div>}}

where \code{logger} is a function taking at least the following arguments: \code{event},
\code{message}, \code{request}, \code{time}, and \code{...}.

\code{fiery} comes with some additional loggers, which either writes all logs to a
file or to the console. A new instance of the file logger can be created with
\code{logger_file(file)}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{app$set_logger(logger_file('fiery_log.log'))
}\if{html}{\out{</div>}}

A new instance of the console logger can be create with \code{logger_console()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{app$set_logger(logger_console())
}\if{html}{\out{</div>}}

Both functions takes a \code{format} a argument that lets you customise how the
log is written. Furthermore the console logger will style the logs with
colour coding depending on the content if the console supports it.

As a last possibility it is possible to use different loggers dependent on
the event by using the switch logger:

\if{html}{\out{<div class="sourceCode">}}\preformatted{app$set_logger(logger_switch(warning =,
                             error = logger_file('errors.log),
                             default = logger_file('info.log')))
}\if{html}{\out{</div>}}
}

\section{Automatic logs}{

\code{fiery} logs a number of different information by itself describing its
operations during run. The following events are send to the log:

\describe{
\item{\emph{start}}{Will be send when the server starts up}
\item{\emph{resume}}{Will be send when the server is resumed}
\item{\emph{stop}}{Will be send when the server stops}
\item{\emph{request}}{Will be send when a request has been handled. The message
will contain information about how long time it took to handle the request
or if it was denied.}
\item{\emph{websocket}}{Will be send every time a WebSocket connection is
established or closed as well as when a message is received or send}
\item{\emph{message}}{Will be send every time a message is emitted by an event
handler or delayed execution handler}
\item{\emph{warning}}{Will be send everytime a warning is emitted by an event
handler or delayed execution handler}
\item{\emph{error}}{Will be send everytime an error is signaled by an event
handler or delayed execution handler. In addition some internal functions
will also emit error event when exceptions are encountered}
}

By default only \emph{message}, \emph{warning} and \emph{error} events will be logged by
sending them to the error stream as a \code{\link[=message]{message()}}.
}

\section{Access Logs}{

Of particular interest are logs that detail requests made to the server.
These are the \code{request} events detailed above. There are different standards
for how requests are logged. \code{fiery} uses the \emph{Common Log Format} by default,
but this can be modified by setting the \code{access_log_format} field to a
\link[glue:glue]{glue} expression that has access to the following variables:

\describe{
\item{\code{start_time}}{The time the request was recieved}
\item{\code{end_time}}{The time the response was send back}
\item{\code{request}}{The \code{Request} object}
\item{\code{response}}{The \code{Response} object}
\item{\code{id}}{The client id}
}

To change the format:

\if{html}{\out{<div class="sourceCode">}}\preformatted{app$access_log_format <- combined_log_format
}\if{html}{\out{</div>}}
}

\section{Custom logs}{

Apart from the standard logs described above it is also possible to send
messages to the log as you please, e.g. inside event handlers. This is done
through the \code{log()} method where you at the very least specify an event and a
message. In general it is better to send messages through \code{log()} rather than
with \code{warning()} and \code{stop()} even though the latters will eventually be
caught, as it gives you more control over the logging and what should happen
in the case of an exception.

An example of using \code{log()} in a handler could be:

\if{html}{\out{<div class="sourceCode">}}\preformatted{app$on('header', function(server, id, request) \{
  server$log('info', paste0('request from ', id, ' received'), request)
\})
}\if{html}{\out{</div>}}

Which would log the timepoint the headers of a request has been recieved.
}

\keyword{datasets}
