% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty-bootstrap.R
\name{uncertainty_bootstrap}
\alias{uncertainty_bootstrap}
\title{Parametric Bootstrap Uncertainty Quantification}
\usage{
uncertainty_bootstrap(
  data,
  distribution,
  method,
  prior = NULL,
  ns_years = NULL,
  ns_structure = NULL,
  ns_slices = NULL,
  alpha = 0.05,
  samples = 10000L,
  periods = c(2, 5, 10, 20, 50, 100)
)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{distribution}{A three-character code indicating the distribution family.
Must be \code{"GUM"}, \code{"NOR"}, \code{"LNO"}, \code{"GEV"}, \code{"GLO"}, \code{"GNO"}, \code{"PE3"}, \code{"LP3"},
or \code{"WEI"}.}

\item{method}{Character scalar specifying the estimation method.
Must be \code{"L-moments"}, \code{"MLE"}, or \code{"GMLE"}.}

\item{prior}{Numeric vector of length 2. Specifies the parameters of the
Beta prior for the shape parameter \eqn{\kappa}.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}

\item{ns_slices}{For NS-FFA only: Numeric vector specifying the years at which to
evaluate the return levels confidence intervals of a nonstationary probability
distribution. \code{ns_slices} do not have to be elements of the \code{ns_years} argument.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}

\item{samples}{Integer scalar. The number of bootstrap samples. Default is 10000.}

\item{periods}{Numeric vector used to set the return periods for FFA.
All entries must be greater than or equal to 1.}
}
\value{
A list containing the following six items:
\itemize{
\item \code{method}: "Bootstrap"
\item \code{distribution}: The \code{distribution} argument.
\item \code{params}: The fitted parameters.
\item \code{ns_structure}: The \code{ns_structure} argument, if given.
\item \code{ns_slices}: The \code{ns_slices} argument, if given.
\item \code{ci}: A dataframe containing confidence intervals (S-FFA only)
\item \code{ci_list}: A list of dataframes containing confidence intervals (NS-FFA only).
}

The dataframe(s) in \code{ci} and \code{ci_list} have four columns:
\itemize{
\item \code{estimates}: Estimated quantiles for each return period.
\item \code{lower}: Lower bound of the confidence interval for each return period.
\item \code{upper}: Upper bound of the confidence interval for each return period.
\item \code{periods}: The \code{periods} argument.
}
}
\description{
Computes return level estimates and confidence intervals at the specified return
periods (defaults to 2, 5, 10, 20, 50, and 100 years) using the parametric bootstrap.
This function supports many probability models and parameter estimation methods.

\strong{For NS-FFA}: To perform uncertainty quantification for a nonstationary model,
include the observation years (\code{ns_years}), the nonstationary model structure
(\code{ns_structure}), and a list of years at which to compute the return level estimates
and confidence intervals (\code{ns_slices}).
}
\details{
Bootstrap samples are obtained from the fitted distribution via inverse transform
sampling. For each bootstrapped sample, the parameters are re-estimated based on the
\code{method} argument. Then, the bootstrapped parameters are used to compute a new set of
bootstrapped quantiles. Confidence intervals are obtained from the empirical
nonexceedance probabilities of the bootstrapped quantiles.
}
\note{
The parametric bootstrap is known to give unreasonably wide confidence intervals
for small datasets. If this method yields a confidence interval that is at least
5 times greater than the magnitude of the return levels, it will return an error
and recommend \code{\link[=uncertainty_rfpl]{uncertainty_rfpl()}} or \code{\link[=uncertainty_rfgpl]{uncertainty_rfgpl()}} as alternatives.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
uncertainty_bootstrap(data, "WEI", "L-moments")

}
\references{
Vidrio-Sahagún, C.T., He, J. Enhanced profile likelihood method for the nonstationary
hydrological frequency analysis, Advances in Water Resources 161, 10451 (2022).
\doi{10.1016/j.advwatres.2022.104151}
}
\seealso{
\code{\link[=fit_lmoments]{fit_lmoments()}}, \code{\link[=fit_mle]{fit_mle()}}, \code{\link[=fit_gmle]{fit_gmle()}}, \code{\link[=utils_sample_lmoments]{utils_sample_lmoments()}}
\code{\link[=utils_quantiles]{utils_quantiles()}}, \code{\link[=plot_sffa_estimates]{plot_sffa_estimates()}}, \code{\link[=plot_nsffa_estimates]{plot_nsffa_estimates()}}
}
