% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\docType{data}
\name{ljung_box}
\alias{ljung_box}
\alias{box_pierce}
\alias{portmanteau_tests}
\title{Portmanteau tests}
\format{
An object of class \code{list} of length 2.
}
\usage{
ljung_box(x, lag = 1, dof = 0, ...)

box_pierce(x, lag = 1, dof = 0, ...)

portmanteau_tests
}
\arguments{
\item{x}{A numeric vector}

\item{lag}{The number of lag autocorrelation coefficients to use in calculating the statistic}

\item{dof}{Degrees of freedom of the fitted model (useful if x is a series of residuals).}

\item{...}{Unused.}
}
\value{
A vector of numeric features for the test's statistic and p-value.
}
\description{
Compute the Box–Pierce or Ljung–Box test statistic for examining the null hypothesis of independence in a given time series. These are sometimes known as ‘portmanteau’ tests.
}
\examples{
ljung_box(rnorm(100))

box_pierce(rnorm(100))
}
\seealso{
\code{\link[stats:box.test]{stats::Box.test()}}
}
\keyword{datasets}
