% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{gg_season}
\alias{gg_season}
\title{Seasonal plot}
\usage{
gg_season(
  data,
  y = NULL,
  period = NULL,
  facet_period = NULL,
  max_col = Inf,
  max_col_discrete = 7,
  pal = (scales::hue_pal())(9),
  polar = FALSE,
  labels = c("none", "left", "right", "both"),
  labels_repel = FALSE,
  labels_left_nudge = 0,
  labels_right_nudge = 0,
  ...
)
}
\arguments{
\item{data}{A tidy time series object (tsibble)}

\item{y}{The variable to plot (a bare expression). If NULL, it will
automatically selected from the data.}

\item{period}{The seasonal period to display. If NULL (default),
the largest frequency in the data is used. If numeric, it represents
the frequency times the interval between observations. If a string
(e.g., "1y" for 1 year, "3m" for 3 months, "1d" for 1 day,
"1h" for 1 hour, "1min" for 1 minute, "1s" for 1 second),
it's converted to a Period class object from the lubridate package.
Note that the data must have at least one observation per seasonal period,
and the period cannot be smaller than the observation interval.}

\item{facet_period}{A secondary seasonal period to facet by
(typically smaller than period).}

\item{max_col}{The maximum number of colours to display on the plot. If the
number of seasonal periods in the data is larger than \code{max_col}, the plot
will not include a colour. Use \code{max_col = 0} to never colour the lines, or Inf
to always colour the lines. If labels are used, then max_col will be ignored.}

\item{max_col_discrete}{The maximum number of colours to show using a discrete colour scale.}

\item{pal}{A colour palette to be used.}

\item{polar}{If TRUE, the season plot will be shown on polar coordinates.}

\item{labels}{Position of the labels for seasonal period identifier.}

\item{labels_repel}{If TRUE, the seasonal period identifying labels will be repelled with the ggrepel package.}

\item{labels_left_nudge, labels_right_nudge}{Allows seasonal period identifying labels to be nudged to the left or right from their default position.}

\item{...}{Additional arguments passed to geom_line()}
}
\value{
A ggplot object showing a seasonal plot of a time series.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
\code{gg_season()} was soft deprecated in feasts 0.4.2. Please use \code{ggtime::gg_season()} instead.

Produces a time series seasonal plot. A seasonal plot is similar to a regular
time series plot, except the x-axis shows data from within each season. This
plot type allows the underlying seasonal pattern to be seen more clearly,
and is especially useful in identifying years in which the pattern changes.
}
\examples{
library(tsibble)
library(dplyr)
tsibbledata::aus_retail \%>\%
  filter(
    State == "Victoria",
    Industry == "Cafes, restaurants and catering services"
  ) \%>\%
  gg_season(Turnover)

}
\references{
Hyndman and Athanasopoulos (2019) Forecasting: principles and practice,
3rd edition, OTexts: Melbourne, Australia. https://OTexts.com/fpp3/
}
