Hraw <- function (X, H)
{
if (missing(X))
stop("The data set must be given")
if (is.null(X))
stop("The data set X is empty")
X=as.matrix(X)
if (any(is.na(X)))
stop("The data set X must not contain NA values")
if (!is.numeric(X))
stop("The data set X is not a numeric data.frame or matrix")
if (missing(H))
stop("The prototype matrix H must be given")
if (is.null(H))
stop("The prototype matrix H is empty")
H=as.matrix(H)
if (any(is.na(H)))
stop("The prototype matrix H must not contain NA values")
if (!is.numeric(H))
stop("The prototype matrix H is not numeric")
if (ncol(H)!=ncol(X))
stop("The numbers of columns of H and X must be the same")
k=nrow(H)
p=ncol(H)
H.raw=H*(matrix(1,k,p)%*%diag(apply(X,2,sd),nrow=p))+matrix(1,k,p)%*%diag(apply(X,2,mean),nrow=p)
if (is.null(rownames(H)))
rownames(H.raw)=paste("Clus",1:k,sep=" ")
else
rownames(H.raw)=rownames(H)
if (is.null(colnames(H)))
colnames(H.raw)=paste("Var",1:p,sep=" ")
else
colnames(H.raw)=colnames(H)
return(H.raw)
}
