% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_group_split.R
\name{f_group_split}
\alias{f_group_split}
\title{Alternative to \code{dplyr::group_split}}
\usage{
f_group_split(
  .data,
  ...,
  .add = FALSE,
  .order = group_by_order_default(.data),
  .by = NULL,
  .cols = NULL,
  .drop = df_group_by_drop_default(.data)
)
}
\arguments{
\item{.data}{data frame.}

\item{...}{Variables to group by.}

\item{.add}{Should groups be added to existing groups?
Default is \code{FALSE}.}

\item{.order}{Should groups be ordered? If \code{FALSE}
groups will be ordered based on first-appearance. \cr
Typically, setting order to \code{FALSE} is faster.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using \code{tidyselect}.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{.drop}{Should unused factor levels be dropped? Default is \code{TRUE}.}
}
\value{
A list of data frames split by group.
}
\description{
Alternative to \code{dplyr::group_split}
}
